/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.Point;
import java.awt.Rectangle;
import javax.imageio.IIOParamController;
import javax.imageio.ImageTypeSpecifier;

public abstract class IIOParam {
    protected IIOParamController controller = null;
    protected IIOParamController defaultController = null;
    protected Point destinationOffset = new Point(0, 0);
    protected ImageTypeSpecifier destinationType = null;
    protected int[] sourceBands = null;
    protected Rectangle sourceRegion = null;
    protected int sourceXSubsampling = 1;
    protected int sourceYSubsampling = 1;
    protected int subsamplingXOffset = 0;
    protected int subsamplingYOffset = 0;
    private boolean no_controller = false;

    protected IIOParam() {
    }

    public boolean activateController() {
        if (this.controller == null) {
            if (this.defaultController == null || this.no_controller) {
                return false;
            }
            return this.defaultController.activate(this);
        }
        return this.controller.activate(this);
    }

    public IIOParamController getController() {
        return this.controller == null ? (this.no_controller ? null : this.defaultController) : this.controller;
    }

    public IIOParamController getDefaultController() {
        return this.defaultController;
    }

    public Point getDestinationOffset() {
        return this.destinationOffset;
    }

    public ImageTypeSpecifier getDestinationType() {
        return this.destinationType;
    }

    public int[] getSourceBands() {
        if (this.sourceBands == null) {
            return null;
        }
        int[] sourceBandsCopy = new int[this.sourceBands.length];
        System.arraycopy(this.sourceBands, 0, sourceBandsCopy, 0, this.sourceBands.length);
        return sourceBandsCopy;
    }

    public Rectangle getSourceRegion() {
        return this.sourceRegion;
    }

    public int getSourceXSubsampling() {
        return this.sourceXSubsampling;
    }

    public int getSourceYSubsampling() {
        return this.sourceYSubsampling;
    }

    public int getSubsamplingXOffset() {
        return this.subsamplingXOffset;
    }

    public int getSubsamplingYOffset() {
        return this.subsamplingYOffset;
    }

    public boolean hasController() {
        return this.getController() != null;
    }

    public void setController(IIOParamController controller) {
        if (controller == this.defaultController) {
            this.controller = null;
            this.no_controller = false;
        } else {
            this.no_controller = controller == null;
            this.controller = controller;
        }
    }

    public void setDestinationType(ImageTypeSpecifier destinationType) {
        this.destinationType = destinationType;
    }

    public void setDestinationOffset(Point destinationOffset) {
        if (destinationOffset == null) {
            throw new IllegalArgumentException("destinationOffset is null");
        }
        this.destinationOffset = destinationOffset;
    }

    public void setSourceBands(int[] sourceBands) {
        int[] sourceBandsCopy = new int[sourceBands.length];
        System.arraycopy(sourceBands, 0, sourceBandsCopy, 0, sourceBands.length);
        this.sourceBands = sourceBandsCopy;
    }

    public void setSourceRegion(Rectangle sourceRegion) {
        if (sourceRegion != null && (sourceRegion.x < 0 || sourceRegion.y < 0 || sourceRegion.width <= 0 || sourceRegion.height <= 0)) {
            throw new IllegalArgumentException("illegal source region");
        }
        if (sourceRegion != null) {
            int num_rows = (sourceRegion.height - this.subsamplingYOffset + this.sourceYSubsampling - 1) / this.sourceYSubsampling;
            int num_columns = (sourceRegion.width - this.subsamplingXOffset + this.sourceXSubsampling - 1) / this.sourceXSubsampling;
            if (num_rows <= 0 || num_columns <= 0) {
                throw new IllegalStateException("zero pixels in source region");
            }
        }
        this.sourceRegion = sourceRegion;
    }

    public void setSourceSubsampling(int sourceXSubsampling, int sourceYSubsampling, int subsamplingXOffset, int subsamplingYOffset) {
        if (subsamplingXOffset < 0 || subsamplingYOffset < 0) {
            throw new IllegalArgumentException("subsampling offset < 0");
        }
        if (this.sourceRegion != null) {
            int num_rows = (this.sourceRegion.height - subsamplingYOffset + sourceYSubsampling - 1) / sourceYSubsampling;
            int num_columns = (this.sourceRegion.width - subsamplingXOffset + sourceXSubsampling - 1) / sourceXSubsampling;
            if (num_rows <= 0 || num_columns <= 0) {
                throw new IllegalStateException("subsampling parameters would produce zero pixel samples in source region");
            }
        }
        this.sourceXSubsampling = sourceXSubsampling;
        this.sourceYSubsampling = sourceYSubsampling;
        this.subsamplingXOffset = subsamplingXOffset;
        this.subsamplingYOffset = subsamplingYOffset;
    }
}

