/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import gnu.javax.swing.tree.GnuPath;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableHeightLayoutCache
extends AbstractLayoutCache {
    private static final Rectangle RECT_CACHE = new Rectangle();
    Set<Object> expanded = new HashSet<Object>();
    Hashtable<Object, NodeRecord> nodes = new Hashtable();
    ArrayList<Object> row2node = new ArrayList();
    boolean dirty;
    int totalHeight;
    int maximalWidth;

    @Override
    public int getRowCount() {
        if (this.dirty) {
            this.update();
        }
        return this.row2node.size();
    }

    private final void update() {
        this.nodes.clear();
        this.row2node.clear();
        this.maximalWidth = 0;
        this.totalHeight = 0;
        if (this.treeModel == null) {
            return;
        }
        Object root = this.treeModel.getRoot();
        this.countRows(root, null, 0, 0);
        this.dirty = false;
    }

    private final int countRows(Object node2, Object parent, int depth, int y) {
        boolean visible = node2 != this.treeModel.getRoot() || this.rootVisible;
        int row = this.row2node.size();
        if (visible) {
            this.row2node.add(node2);
        }
        NodeRecord nr = new NodeRecord(row, depth, node2, parent);
        AbstractLayoutCache.NodeDimensions d = this.getNodeDimensions();
        Rectangle r = RECT_CACHE;
        if (d != null) {
            r = d.getNodeDimensions(node2, row, depth, nr.isExpanded, r);
        } else {
            r.setBounds(0, 0, 0, 0);
        }
        r.y = !visible ? -1 : Math.max(0, y);
        if (this.isFixedRowHeight()) {
            r.height = this.getRowHeight();
        }
        nr.bounds.setBounds(r);
        this.nodes.put(node2, nr);
        if (visible) {
            y += r.height;
        }
        int sc = this.treeModel.getChildCount(node2);
        int deeper = depth + 1;
        if (this.expanded.contains(node2)) {
            int i = 0;
            while (i < sc) {
                Object child = this.treeModel.getChild(node2, i);
                y = this.countRows(child, node2, deeper, y);
                ++i;
            }
        }
        return y;
    }

    @Override
    public void invalidatePathBounds(TreePath path) {
        NodeRecord r = this.nodes.get(path.getLastPathComponent());
        if (r != null) {
            r.bounds = null;
        }
    }

    @Override
    public void invalidateSizes() {
        this.dirty = true;
    }

    @Override
    public void setExpandedState(TreePath path, boolean isExpanded) {
        if (isExpanded) {
            int length = path.getPathCount();
            int i = 0;
            while (i < length) {
                this.expanded.add(path.getPathComponent(i));
                ++i;
            }
        } else {
            this.expanded.remove(path.getLastPathComponent());
        }
        this.dirty = true;
    }

    @Override
    public boolean isExpanded(TreePath path) {
        return this.expanded.contains(path.getLastPathComponent());
    }

    @Override
    public Rectangle getBounds(TreePath path, Rectangle rect) {
        if (path == null) {
            return null;
        }
        if (this.dirty) {
            this.update();
        }
        Object last = path.getLastPathComponent();
        Rectangle result = null;
        NodeRecord r = this.nodes.get(last);
        if (r != null) {
            result = rect;
            if (result == null) {
                result = new Rectangle(r.bounds);
            } else {
                result.setBounds(r.bounds);
            }
        }
        return result;
    }

    @Override
    public TreePath getPathForRow(int row) {
        if (this.dirty) {
            this.update();
        }
        TreePath path = null;
        Enumeration<NodeRecord> nodesEnum = this.nodes.elements();
        while (nodesEnum.hasMoreElements() && path == null) {
            NodeRecord record = nodesEnum.nextElement();
            if (record.row != row) continue;
            path = record.getPath();
        }
        return path;
    }

    @Override
    public int getRowForPath(TreePath path) {
        NodeRecord r;
        if (path == null) {
            return -1;
        }
        if (this.dirty) {
            this.update();
        }
        if ((r = this.nodes.get(path.getLastPathComponent())) == null) {
            return -1;
        }
        return r.row;
    }

    @Override
    public TreePath getPathClosestTo(int x, int y) {
        if (this.dirty) {
            this.update();
        }
        NodeRecord best = null;
        Enumeration<NodeRecord> en = this.nodes.elements();
        int dist = Integer.MAX_VALUE;
        while (en.hasMoreElements() && dist > 0) {
            NodeRecord r = en.nextElement();
            if (best == null) {
                best = r;
                dist = this.distance(r.getBounds(), x, y);
                continue;
            }
            int rr = this.distance(r.getBounds(), x, y);
            if (rr >= dist) continue;
            best = r;
            dist = rr;
        }
        if (best == null) {
            return null;
        }
        return best.getPath();
    }

    int distance(Rectangle r, int x, int y) {
        if (y < r.y) {
            return r.y - y;
        }
        if (y > r.y + r.height - 1) {
            return y - (r.y + r.height - 1);
        }
        return 0;
    }

    @Override
    public int getVisibleChildCount(TreePath path) {
        if (!this.isExpanded(path) || this.treeModel == null) {
            return 0;
        }
        return this.treeModel.getChildCount(path.getLastPathComponent());
    }

    @Override
    public Enumeration<TreePath> getVisiblePathsFrom(TreePath parentPath) {
        if (this.dirty) {
            this.update();
        }
        Vector<Object> p = new Vector<Object>(parentPath.getPathCount());
        int i = 0;
        while (i < parentPath.getPathCount()) {
            Object node2 = parentPath.getPathComponent(i);
            NodeRecord nr = this.nodes.get(node2);
            if (nr != null && nr.row >= 0) {
                p.add(node2);
            }
            ++i;
        }
        return p.elements();
    }

    @Override
    public boolean getExpandedState(TreePath path) {
        return this.expanded.contains(path.getLastPathComponent());
    }

    @Override
    public void treeNodesChanged(TreeModelEvent event) {
        this.dirty = true;
    }

    @Override
    public void treeNodesInserted(TreeModelEvent event) {
        this.dirty = true;
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent event) {
        this.dirty = true;
    }

    @Override
    public void treeStructureChanged(TreeModelEvent event) {
        this.dirty = true;
    }

    @Override
    public void setModel(TreeModel newModel) {
        this.treeModel = newModel;
        this.dirty = true;
        if (this.treeModel != null) {
            this.expanded.add(this.treeModel.getRoot());
        }
    }

    @Override
    public void setRootVisible(boolean visible) {
        this.rootVisible = visible;
        this.dirty = true;
    }

    @Override
    public int getPreferredHeight() {
        if (this.dirty) {
            this.update();
        }
        int height = 0;
        int rowCount = this.getRowCount();
        if (rowCount > 0) {
            NodeRecord last = this.nodes.get(this.row2node.get(rowCount - 1));
            height = last.bounds.y + last.bounds.height;
        }
        return height;
    }

    @Override
    public int getPreferredWidth(Rectangle value) {
        if (this.dirty) {
            this.update();
        }
        this.maximalWidth = 0;
        Enumeration<NodeRecord> en = this.nodes.elements();
        while (en.hasMoreElements()) {
            NodeRecord nr = en.nextElement();
            if (nr == null) continue;
            Rectangle r = nr.getBounds();
            int width = r.x + r.width;
            if (width <= this.maximalWidth) continue;
            this.maximalWidth = width;
        }
        return this.maximalWidth;
    }

    @Override
    public void setNodeDimensions(AbstractLayoutCache.NodeDimensions dim) {
        super.setNodeDimensions(dim);
        this.dirty = true;
    }

    @Override
    public void setRowHeight(int height) {
        super.setRowHeight(height);
        this.dirty = true;
    }

    class NodeRecord {
        final int row;
        final int depth;
        final Object parent;
        final Object node;
        final boolean isExpanded;
        Rectangle bounds;
        private TreePath path;

        NodeRecord(int aRow, int aDepth, Object aNode, Object aParent) {
            this.row = aRow;
            this.depth = aDepth;
            this.parent = aParent;
            this.node = aNode;
            this.isExpanded = VariableHeightLayoutCache.this.expanded.contains(aNode);
            this.bounds = new Rectangle(0, -1, 0, 0);
        }

        TreePath getPath() {
            if (this.path == null) {
                int n;
                int nc;
                boolean lastChild = false;
                if (this.parent != null && (nc = VariableHeightLayoutCache.this.treeModel.getChildCount(this.parent)) > 0 && (n = VariableHeightLayoutCache.this.treeModel.getIndexOfChild(this.parent, this.node)) == nc - 1) {
                    lastChild = true;
                }
                LinkedList<Object> lpath = new LinkedList<Object>();
                NodeRecord rp = this;
                while (rp != null) {
                    lpath.addFirst(rp.node);
                    if (rp.parent != null) {
                        Object parent = rp.parent;
                        rp = VariableHeightLayoutCache.this.nodes.get(parent);
                        if (rp != null) continue;
                        lpath.addFirst(parent);
                        continue;
                    }
                    rp = null;
                }
                this.path = new GnuPath(lpath.toArray(), lastChild);
            }
            return this.path;
        }

        Rectangle getBounds() {
            return this.bounds;
        }
    }
}

