/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.CompositeView;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class BoxView
extends CompositeView {
    private int myAxis;
    private boolean[] layoutValid = new boolean[2];
    private boolean[] requirementsValid = new boolean[2];
    private int[][] spans = new int[2][];
    private int[][] offsets = new int[2][];
    private SizeRequirements[] requirements = new SizeRequirements[2];
    private int[] span = new int[2];
    private final Rectangle tmpRect = new Rectangle();
    private Rectangle clipRect = new Rectangle();

    public BoxView(Element element, int axis) {
        super(element);
        this.myAxis = axis;
        this.layoutValid[0] = false;
        this.layoutValid[1] = false;
        this.requirementsValid[0] = false;
        this.requirementsValid[1] = false;
        this.span[0] = 0;
        this.span[1] = 0;
        this.requirements[0] = new SizeRequirements();
        this.requirements[1] = new SizeRequirements();
        this.spans[0] = new int[0];
        this.spans[1] = new int[0];
        this.offsets[0] = new int[0];
        this.offsets[1] = new int[0];
    }

    public int getAxis() {
        return this.myAxis;
    }

    public void setAxis(int axis) {
        boolean changed = axis != this.myAxis;
        this.myAxis = axis;
        if (changed) {
            this.preferenceChanged(null, true, true);
        }
    }

    public void layoutChanged(int axis) {
        if (axis != 0 && axis != 1) {
            throw new IllegalArgumentException("Invalid axis parameter.");
        }
        this.layoutValid[axis] = false;
    }

    protected boolean isLayoutValid(int axis) {
        if (axis != 0 && axis != 1) {
            throw new IllegalArgumentException("Invalid axis parameter.");
        }
        return this.layoutValid[axis];
    }

    protected void paintChild(Graphics g, Rectangle alloc, int index) {
        View child = this.getView(index);
        child.paint(g, alloc);
    }

    public void replace(int offset, int length, View[] views) {
        super.replace(offset, length, views);
        int newItems = views != null ? views.length : 0;
        int minor = 1 - this.myAxis;
        this.offsets[this.myAxis] = this.replaceLayoutArray(this.offsets[this.myAxis], offset, newItems);
        this.spans[this.myAxis] = this.replaceLayoutArray(this.spans[this.myAxis], offset, newItems);
        this.layoutValid[this.myAxis] = false;
        this.requirementsValid[this.myAxis] = false;
        this.offsets[minor] = this.replaceLayoutArray(this.offsets[minor], offset, newItems);
        this.spans[minor] = this.replaceLayoutArray(this.spans[minor], offset, newItems);
        this.layoutValid[minor] = false;
        this.requirementsValid[minor] = false;
    }

    private int[] replaceLayoutArray(int[] oldArray, int offset, int newItems) {
        int num = this.getViewCount();
        int[] newArray = new int[num];
        System.arraycopy(oldArray, 0, newArray, 0, offset);
        System.arraycopy(oldArray, offset, newArray, offset + newItems, num - newItems - offset);
        return newArray;
    }

    public void paint(Graphics g, Shape a) {
        Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        alloc = this.getInsideAllocation(alloc);
        int count = this.getViewCount();
        int i = 0;
        while (i < count) {
            this.getView(i);
            this.tmpRect.setBounds(alloc);
            this.childAllocation(i, this.tmpRect);
            if (g.hitClip(this.tmpRect.x, this.tmpRect.y, this.tmpRect.width, this.tmpRect.height)) {
                this.paintChild(g, this.tmpRect, i);
            }
            ++i;
        }
    }

    public float getPreferredSpan(int axis) {
        this.updateRequirements(axis);
        float margin = axis == 0 ? (float)(this.getLeftInset() + this.getRightInset()) : (float)(this.getTopInset() + this.getBottomInset());
        return (float)this.requirements[axis].preferred + margin;
    }

    public float getMaximumSpan(int axis) {
        this.updateRequirements(axis);
        float margin = axis == 0 ? (float)(this.getLeftInset() + this.getRightInset()) : (float)(this.getTopInset() + this.getBottomInset());
        return (float)this.requirements[axis].maximum + margin;
    }

    public float getMinimumSpan(int axis) {
        this.updateRequirements(axis);
        float margin = axis == 0 ? (float)(this.getLeftInset() + this.getRightInset()) : (float)(this.getTopInset() + this.getBottomInset());
        return (float)this.requirements[axis].minimum + margin;
    }

    protected SizeRequirements baselineRequirements(int axis, SizeRequirements sr) {
        if (sr == null) {
            sr = new SizeRequirements();
        }
        sr.alignment = 0.5f;
        int totalAscentMin = 0;
        int totalAscentPref = 0;
        int totalAscentMax = 0;
        int totalDescentMin = 0;
        int totalDescentPref = 0;
        int totalDescentMax = 0;
        int count = this.getViewCount();
        int i = 0;
        while (i < count) {
            View v = this.getView(i);
            float align = v.getAlignment(axis);
            int span = (int)v.getPreferredSpan(axis);
            int ascent = (int)(align * (float)span);
            int descent = span - ascent;
            totalAscentPref = Math.max(ascent, totalAscentPref);
            totalDescentPref = Math.max(descent, totalDescentPref);
            if (v.getResizeWeight(axis) > 0) {
                span = (int)v.getMinimumSpan(axis);
                ascent = (int)(align * (float)span);
                descent = span - ascent;
                totalAscentMin = Math.max(ascent, totalAscentMin);
                totalDescentMin = Math.max(descent, totalDescentMin);
                span = (int)v.getMaximumSpan(axis);
                ascent = (int)(align * (float)span);
                descent = span - ascent;
                totalAscentMax = Math.max(ascent, totalAscentMax);
                totalDescentMax = Math.max(descent, totalDescentMax);
            } else {
                totalAscentMin = Math.max(ascent, totalAscentMin);
                totalDescentMin = Math.max(descent, totalDescentMin);
                totalAscentMax = Math.max(ascent, totalAscentMax);
                totalDescentMax = Math.max(descent, totalDescentMax);
            }
            ++i;
        }
        sr.preferred = (int)Math.min((long)totalAscentPref + (long)totalDescentPref, Integer.MAX_VALUE);
        if (sr.preferred > 0) {
            sr.alignment = (float)totalAscentPref / (float)sr.preferred;
        }
        if (sr.alignment == 0.0f) {
            sr.minimum = totalDescentMin;
            sr.maximum = totalDescentMax;
        } else if (sr.alignment == 1.0f) {
            sr.minimum = totalAscentMin;
            sr.maximum = totalAscentMax;
        } else {
            sr.minimum = Math.max((int)((float)totalAscentMin / sr.alignment), (int)((float)totalDescentMin / (1.0f - sr.alignment)));
            sr.maximum = Math.min((int)((float)totalAscentMax / sr.alignment), (int)((float)totalDescentMax / (1.0f - sr.alignment)));
        }
        return sr;
    }

    protected void baselineLayout(int span, int axis, int[] offsets, int[] spans) {
        int totalAscent = (int)((float)span * this.getAlignment(axis));
        int totalDescent = span - totalAscent;
        int count = this.getViewCount();
        int i = 0;
        while (i < count) {
            int viewSpan;
            View v = this.getView(i);
            float align = v.getAlignment(axis);
            if (v.getResizeWeight(axis) > 0) {
                int min = (int)v.getMinimumSpan(axis);
                int max = (int)v.getMaximumSpan(axis);
                if (align == 0.0f) {
                    viewSpan = Math.max(Math.min(max, totalDescent), min);
                } else if (align == 1.0f) {
                    viewSpan = Math.max(Math.min(max, totalAscent), min);
                } else {
                    int fit = (int)Math.min((float)totalAscent / align, (float)totalDescent / (1.0f - align));
                    viewSpan = Math.max(Math.min(max, fit), min);
                }
            } else {
                viewSpan = (int)v.getPreferredSpan(axis);
            }
            offsets[i] = totalAscent - (int)((float)viewSpan * align);
            spans[i] = viewSpan;
            ++i;
        }
    }

    protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements sr) {
        SizeRequirements res = sr;
        if (res == null) {
            res = new SizeRequirements();
        }
        float min = 0.0f;
        float pref = 0.0f;
        float max = 0.0f;
        int n = this.getViewCount();
        int i = 0;
        while (i < n) {
            View child = this.getView(i);
            min += child.getMinimumSpan(axis);
            pref += child.getPreferredSpan(axis);
            max += child.getMaximumSpan(axis);
            ++i;
        }
        res.minimum = (int)min;
        res.preferred = (int)pref;
        res.maximum = (int)max;
        res.alignment = 0.5f;
        return res;
    }

    protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements sr) {
        SizeRequirements res = sr;
        if (res == null) {
            res = new SizeRequirements();
        }
        res.minimum = 0;
        res.preferred = 0;
        res.maximum = Integer.MAX_VALUE;
        res.alignment = 0.5f;
        int n = this.getViewCount();
        int i = 0;
        while (i < n) {
            View child = this.getView(i);
            res.minimum = Math.max((int)child.getMinimumSpan(axis), res.minimum);
            res.preferred = Math.max((int)child.getPreferredSpan(axis), res.preferred);
            res.maximum = Math.max((int)child.getMaximumSpan(axis), res.maximum);
            ++i;
        }
        return res;
    }

    protected boolean isBefore(int x, int y, Rectangle r) {
        boolean result = false;
        result = this.myAxis == 0 ? x < r.x : y < r.y;
        return result;
    }

    protected boolean isAfter(int x, int y, Rectangle r) {
        boolean result = false;
        result = this.myAxis == 0 ? x > r.x + r.width : y > r.y + r.height;
        return result;
    }

    protected View getViewAtPoint(int x, int y, Rectangle r) {
        View result = null;
        int count = this.getViewCount();
        if (this.myAxis == 0) {
            if (x < r.x + this.offsets[0][0]) {
                this.childAllocation(0, r);
                result = this.getView(0);
            } else {
                int i = 0;
                while (i < count && result == null) {
                    if (x < r.x + this.offsets[0][i]) {
                        this.childAllocation(i - 1, r);
                        result = this.getView(i - 1);
                    }
                    ++i;
                }
            }
        } else if (y < r.y + this.offsets[1][0]) {
            this.childAllocation(0, r);
            result = this.getView(0);
        } else {
            int i = 0;
            while (i < count && result == null) {
                if (y < r.y + this.offsets[1][i]) {
                    this.childAllocation(i - 1, r);
                    result = this.getView(i - 1);
                }
                ++i;
            }
        }
        if (result == null) {
            this.childAllocation(count - 1, r);
            result = this.getView(count - 1);
        }
        return result;
    }

    protected void childAllocation(int index, Rectangle a) {
        a.x += this.offsets[0][index];
        a.y += this.offsets[1][index];
        a.width = this.spans[0][index];
        a.height = this.spans[1][index];
    }

    protected void layout(int width, int height) {
        this.layoutAxis(0, width);
        this.layoutAxis(1, height);
    }

    private void layoutAxis(int axis, int s) {
        if (this.span[axis] != s) {
            this.layoutValid[axis] = false;
        }
        if (!this.layoutValid[axis]) {
            this.span[axis] = s;
            this.updateRequirements(axis);
            if (axis == this.myAxis) {
                this.layoutMajorAxis(this.span[axis], axis, this.offsets[axis], this.spans[axis]);
            } else {
                this.layoutMinorAxis(this.span[axis], axis, this.offsets[axis], this.spans[axis]);
            }
            this.layoutValid[axis] = true;
            int viewCount = this.getViewCount();
            int i = 0;
            while (i < viewCount) {
                View v = this.getView(i);
                v.setSize(this.spans[0][i], this.spans[1][i]);
                ++i;
            }
        }
    }

    protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        long sumPref = 0L;
        int n = this.getViewCount();
        int i = 0;
        while (i < n) {
            View child = this.getView(i);
            spans[i] = (int)child.getPreferredSpan(axis);
            sumPref += (long)spans[i];
            ++i;
        }
        long diff = (long)targetSpan - sumPref;
        float factor = 0.0f;
        int[] diffs = null;
        if (diff != 0L) {
            long total = 0L;
            diffs = new int[n];
            int i2 = 0;
            while (i2 < n) {
                int span;
                View child = this.getView(i2);
                if (diff < 0L) {
                    span = (int)child.getMinimumSpan(axis);
                    diffs[i2] = spans[i2] - span;
                } else {
                    span = (int)child.getMaximumSpan(axis);
                    diffs[i2] = span - spans[i2];
                }
                total += (long)span;
                ++i2;
            }
            float maxAdjust = Math.abs(total - sumPref);
            factor = (float)diff / maxAdjust;
            factor = Math.min(factor, 1.0f);
            factor = Math.max(factor, -1.0f);
        }
        int totalOffs = 0;
        int i3 = 0;
        while (i3 < n) {
            offsets[i3] = totalOffs;
            if (diff != 0L) {
                float adjust = factor * (float)diffs[i3];
                int n2 = i3;
                spans[n2] = spans[n2] + Math.round(adjust);
            }
            totalOffs = (int)Math.min((long)totalOffs + (long)spans[i3], Integer.MAX_VALUE);
            ++i3;
        }
    }

    protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        int count = this.getViewCount();
        int i = 0;
        while (i < count) {
            View child = this.getView(i);
            int max = (int)child.getMaximumSpan(axis);
            if (max < targetSpan) {
                float align = child.getAlignment(axis);
                offsets[i] = (int)((float)(targetSpan - max) * align);
                spans[i] = max;
            } else {
                int min = (int)child.getMinimumSpan(axis);
                offsets[i] = 0;
                spans[i] = Math.max(min, targetSpan);
            }
            ++i;
        }
    }

    protected boolean isAllocationValid() {
        return this.isLayoutValid(0) && this.isLayoutValid(1);
    }

    public int getWidth() {
        return this.span[0] + this.getLeftInset() + this.getRightInset();
    }

    public int getHeight() {
        return this.span[1] + this.getTopInset() + this.getBottomInset();
    }

    public void setSize(float width, float height) {
        this.layout((int)(width - (float)this.getLeftInset() - (float)this.getRightInset()), (int)(height - (float)this.getTopInset() - (float)this.getBottomInset()));
    }

    protected int getSpan(int axis, int childIndex) {
        if (axis != 0 && axis != 1) {
            throw new IllegalArgumentException("Illegal axis argument");
        }
        return this.spans[axis][childIndex];
    }

    protected int getOffset(int axis, int childIndex) {
        if (axis != 0 && axis != 1) {
            throw new IllegalArgumentException("Illegal axis argument");
        }
        return this.offsets[axis][childIndex];
    }

    public float getAlignment(int axis) {
        this.updateRequirements(axis);
        return this.requirements[axis].alignment;
    }

    public void preferenceChanged(View child, boolean width, boolean height) {
        if (width) {
            this.layoutValid[0] = false;
            this.requirementsValid[0] = false;
        }
        if (height) {
            this.layoutValid[1] = false;
            this.requirementsValid[1] = false;
        }
        super.preferenceChanged(child, width, height);
    }

    public Shape modelToView(int pos, Shape a, Position.Bias bias) throws BadLocationException {
        if (!this.isAllocationValid()) {
            Rectangle bounds = a.getBounds();
            this.setSize(bounds.width, bounds.height);
        }
        return super.modelToView(pos, a, bias);
    }

    public int getResizeWeight(int axis) {
        if (axis != 0 && axis != 1) {
            throw new IllegalArgumentException("Illegal axis argument");
        }
        this.updateRequirements(axis);
        int weight = 0;
        if (this.requirements[axis].preferred != this.requirements[axis].minimum || this.requirements[axis].preferred != this.requirements[axis].maximum) {
            weight = 1;
        }
        return weight;
    }

    public Shape getChildAllocation(int index, Shape a) {
        Shape ret = null;
        if (this.isAllocationValid() && a != null) {
            ret = super.getChildAllocation(index, a);
        }
        return ret;
    }

    protected void forwardUpdate(DocumentEvent.ElementChange ec, DocumentEvent e, Shape a, ViewFactory vf) {
        boolean wasValid = this.isLayoutValid(this.myAxis);
        super.forwardUpdate(ec, e, a, vf);
        if (wasValid && !this.isLayoutValid(this.myAxis)) {
            Container c = this.getContainer();
            if (a != null && c != null) {
                int pos = e.getOffset();
                int index = this.getViewIndexAtPosition(pos);
                Rectangle r = this.getInsideAllocation(a);
                if (this.myAxis == 0) {
                    r.x += this.offsets[this.myAxis][index];
                    r.width -= this.offsets[this.myAxis][index];
                } else {
                    r.y += this.offsets[this.myAxis][index];
                    r.height -= this.offsets[this.myAxis][index];
                }
                c.repaint(r.x, r.y, r.width, r.height);
            }
        }
    }

    public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
        if (!this.isAllocationValid()) {
            Rectangle r = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            this.setSize(r.width, r.height);
        }
        return super.viewToModel(x, y, a, bias);
    }

    protected boolean flipEastAndWestAtEnds(int position, Position.Bias bias) {
        return super.flipEastAndWestAtEnds(position, bias);
    }

    private void updateRequirements(int axis) {
        if (axis != 1 && axis != 0) {
            throw new IllegalArgumentException("Illegal axis: " + axis);
        }
        if (!this.requirementsValid[axis]) {
            this.requirements[axis] = axis == this.myAxis ? this.calculateMajorAxisRequirements(axis, this.requirements[axis]) : this.calculateMinorAxisRequirements(axis, this.requirements[axis]);
            this.requirementsValid[axis] = true;
        }
    }
}

