/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.imageio.stream.ImageOutputStreamImpl;

public class FileImageOutputStream
extends ImageOutputStreamImpl {
    private RandomAccessFile file;

    public FileImageOutputStream(File file) throws FileNotFoundException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("file may not be null");
        }
        file.canRead();
        this.file = new RandomAccessFile(file, "r");
    }

    public FileImageOutputStream(RandomAccessFile file) {
        if (file == null) {
            throw new IllegalArgumentException("file may not be null");
        }
        this.file = file;
    }

    public void close() throws IOException {
        this.file.close();
    }

    public long length() {
        try {
            return this.file.length();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    public int read() throws IOException {
        this.checkClosed();
        this.setBitOffset(0);
        return this.file.read();
    }

    public int read(byte[] data, int offset, int len) throws IOException {
        this.checkClosed();
        this.setBitOffset(0);
        return this.file.read(data, offset, len);
    }

    public void seek(long position) throws IOException {
        super.seek(position);
        this.file.seek(position);
    }

    public void write(byte[] data, int offset, int len) throws IOException {
        this.checkClosed();
        this.flushBits();
        this.file.write(data, offset, len);
    }

    public void write(int value) throws IOException {
        this.checkClosed();
        this.file.write(value);
    }
}

