/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import gnu.java.lang.CPStringBuilder;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.Bidi;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TextLayout
implements Cloneable {
    private Run[] runs;
    private FontRenderContext frc;
    private char[] string;
    private int offset;
    private int length;
    private Rectangle2D boundsCache;
    private LineMetrics lm;
    private float totalAdvance = -1.0f;
    private Rectangle2D naturalBounds;
    private int[][] charIndices;
    private boolean leftToRight;
    private boolean hasWhitespace = false;
    private Bidi bidi;
    private int[] logicalToVisual;
    private int[] visualToLogical;
    private int hash;
    public static final CaretPolicy DEFAULT_CARET_POLICY = new CaretPolicy();

    public TextLayout(String str, Font font, FontRenderContext frc) {
        this.frc = frc;
        this.string = str.toCharArray();
        this.offset = 0;
        this.length = this.string.length;
        this.lm = font.getLineMetrics(this.string, this.offset, this.length, frc);
        this.getStringProperties();
        if (Bidi.requiresBidi(this.string, this.offset, this.offset + this.length)) {
            this.bidi = new Bidi(str, this.leftToRight ? 0 : 1);
            int rc = this.bidi.getRunCount();
            byte[] table = new byte[rc];
            int i = 0;
            while (i < table.length) {
                table[i] = (byte)this.bidi.getRunLevel(i);
                ++i;
            }
            this.runs = new Run[rc];
            i = 0;
            while (i < rc) {
                int end;
                int start = this.bidi.getRunStart(i);
                if (start != (end = this.bidi.getRunLimit(i))) {
                    GlyphVector gv = font.layoutGlyphVector(frc, this.string, start, end, (table[i] & 1) == 0 ? 0 : 1);
                    this.runs[i] = new Run(gv, font, start, end);
                }
                ++i;
            }
            Bidi.reorderVisually(table, 0, this.runs, 0, this.runs.length);
            ArrayList<Run> cleaned = new ArrayList<Run>(rc);
            int i2 = 0;
            while (i2 < rc) {
                if (this.runs[i2] != null) {
                    cleaned.add(this.runs[i2]);
                }
                ++i2;
            }
            this.runs = new Run[cleaned.size()];
            this.runs = cleaned.toArray(this.runs);
        } else {
            GlyphVector gv = font.layoutGlyphVector(frc, this.string, this.offset, this.length, this.leftToRight ? 0 : 1);
            Run run = new Run(gv, font, 0, this.length);
            this.runs = new Run[]{run};
        }
        this.setCharIndices();
        this.setupMappings();
        this.layoutRuns();
    }

    public TextLayout(String string, Map<? extends AttributedCharacterIterator.Attribute, ?> attributes, FontRenderContext frc) {
        this(string, new Font(attributes), frc);
    }

    public TextLayout(AttributedCharacterIterator text, FontRenderContext frc) {
        this(TextLayout.getText(text), TextLayout.getFont(text), frc);
    }

    TextLayout(TextLayout t, int startIndex, int endIndex) {
        this.frc = t.frc;
        this.boundsCache = null;
        this.lm = t.lm;
        this.leftToRight = t.leftToRight;
        if (endIndex > t.getCharacterCount()) {
            endIndex = t.getCharacterCount();
        }
        this.string = t.string;
        this.offset = startIndex + this.offset;
        this.length = endIndex - startIndex;
        int startingRun = t.charIndices[startIndex][0];
        int nRuns = 1 + t.charIndices[endIndex - 1][0] - startingRun;
        this.runs = new Run[nRuns];
        int i = 0;
        while (i < nRuns) {
            Run run = t.runs[i + startingRun];
            GlyphVector gv = run.glyphVector;
            Font font = run.font;
            int beginGlyphIndex = i > 0 ? 0 : t.charIndices[startIndex][1];
            int numEntries = i < nRuns - 1 ? gv.getNumGlyphs() : 1 + t.charIndices[endIndex - 1][1] - beginGlyphIndex;
            int[] codes = gv.getGlyphCodes(beginGlyphIndex, numEntries, null);
            gv = font.createGlyphVector(this.frc, codes);
            this.runs[i] = new Run(gv, font, run.runStart - startIndex, run.runEnd - startIndex);
            ++i;
        }
        this.runs[nRuns - 1].runEnd = endIndex - 1;
        this.setCharIndices();
        this.setupMappings();
        this.determineWhiteSpace();
        this.layoutRuns();
    }

    private void setCharIndices() {
        this.charIndices = new int[this.getCharacterCount()][2];
        int i = 0;
        int currentChar = 0;
        int run = 0;
        while (run < this.runs.length) {
            currentChar = -1;
            Run current = this.runs[run];
            GlyphVector gv = current.glyphVector;
            int gi = 0;
            while (gi < gv.getNumGlyphs()) {
                if (gv.getGlyphCharIndex(gi) != currentChar) {
                    this.charIndices[i][0] = run;
                    this.charIndices[i][1] = gi;
                    currentChar = gv.getGlyphCharIndex(gi);
                    ++i;
                }
                ++gi;
            }
            ++run;
        }
    }

    private void setupMappings() {
        int numChars = this.getCharacterCount();
        this.logicalToVisual = new int[numChars];
        this.visualToLogical = new int[numChars];
        int lIndex = 0;
        int vIndex = 0;
        int i = 0;
        while (i < this.runs.length) {
            Run run = this.runs[i];
            if (run.isLeftToRight()) {
                lIndex = run.runStart;
                while (lIndex < run.runEnd) {
                    this.logicalToVisual[lIndex] = vIndex;
                    this.visualToLogical[vIndex] = lIndex++;
                    ++vIndex;
                }
            } else {
                lIndex = run.runEnd - 1;
                while (lIndex >= run.runStart) {
                    this.logicalToVisual[lIndex] = vIndex;
                    this.visualToLogical[vIndex] = lIndex--;
                    ++vIndex;
                }
            }
            ++i;
        }
    }

    private static String getText(AttributedCharacterIterator iter) {
        CPStringBuilder sb = new CPStringBuilder();
        int idx = iter.getIndex();
        char c = iter.first();
        while (c != '\uffff') {
            sb.append(c);
            c = iter.next();
        }
        iter.setIndex(idx);
        return sb.toString();
    }

    private static Font getFont(AttributedCharacterIterator iter) {
        Font f = (Font)iter.getAttribute(TextAttribute.FONT);
        if (f == null) {
            Float i = (Float)iter.getAttribute(TextAttribute.SIZE);
            int size = i != null ? (int)i.floatValue() : 14;
            f = new Font("Dialog", 0, size);
        }
        return f;
    }

    private void getStringProperties() {
        boolean gotDirection = false;
        int i = this.offset;
        int endOffs = this.offset + this.length;
        this.leftToRight = true;
        while (i < endOffs && !gotDirection) {
            switch (Character.getDirectionality(this.string[i++])) {
                case 0: 
                case 14: 
                case 15: {
                    gotDirection = true;
                    break;
                }
                case 1: 
                case 2: 
                case 16: 
                case 17: {
                    this.leftToRight = false;
                    gotDirection = true;
                }
            }
        }
        this.determineWhiteSpace();
    }

    private void determineWhiteSpace() {
        int i = this.offset + this.length - 1;
        this.hasWhitespace = false;
        while (i >= this.offset && Character.isWhitespace(this.string[i])) {
            --i;
        }
        while (i >= this.offset) {
            if (!Character.isWhitespace(this.string[i--])) continue;
            this.hasWhitespace = true;
        }
    }

    protected Object clone() {
        return new TextLayout(this, 0, this.length);
    }

    public void draw(Graphics2D g2, float x, float y) {
        int i = 0;
        while (i < this.runs.length) {
            Run run = this.runs[i];
            GlyphVector gv = run.glyphVector;
            g2.drawGlyphVector(gv, x, y);
            Rectangle2D r = gv.getLogicalBounds();
            x = (float)((double)x + r.getWidth());
            ++i;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextLayout)) {
            return false;
        }
        return this.equals((TextLayout)obj);
    }

    public boolean equals(TextLayout tl) {
        if (this.runs.length != tl.runs.length) {
            return false;
        }
        int i = 0;
        while (i < this.runs.length) {
            if (!this.runs[i].equals(tl.runs[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public float getAdvance() {
        if (this.totalAdvance == -1.0f) {
            this.totalAdvance = 0.0f;
            int i = 0;
            while (i < this.runs.length) {
                Run run = this.runs[i];
                GlyphVector gv = run.glyphVector;
                this.totalAdvance = (float)((double)this.totalAdvance + gv.getLogicalBounds().getWidth());
                ++i;
            }
        }
        return this.totalAdvance;
    }

    public float getAscent() {
        return this.lm.getAscent();
    }

    public byte getBaseline() {
        return (byte)this.lm.getBaselineIndex();
    }

    public float[] getBaselineOffsets() {
        return this.lm.getBaselineOffsets();
    }

    public Shape getBlackBoxBounds(int firstEndpoint, int secondEndpoint) {
        GlyphVector gv;
        Run run;
        if (secondEndpoint - firstEndpoint <= 0) {
            return new Rectangle2D.Float();
        }
        if (firstEndpoint < 0 || secondEndpoint > this.getCharacterCount()) {
            return new Rectangle2D.Float();
        }
        GeneralPath gp = new GeneralPath();
        int ri = this.charIndices[firstEndpoint][0];
        int cfr_ignored_0 = this.charIndices[firstEndpoint][1];
        double advance = 0.0;
        int i = 0;
        while (i < ri) {
            run = this.runs[i];
            gv = run.glyphVector;
            advance += gv.getLogicalBounds().getWidth();
            ++i;
        }
        i = ri;
        while (i <= this.charIndices[secondEndpoint - 1][0]) {
            run = this.runs[i];
            gv = run.glyphVector;
            int dg = i == this.charIndices[secondEndpoint - 1][0] ? this.charIndices[secondEndpoint - 1][1] : gv.getNumGlyphs() - 1;
            int j = 0;
            while (j <= dg) {
                Rectangle2D r2 = gv.getGlyphVisualBounds(j).getBounds2D();
                gv.getGlyphPosition(j);
                r2.setRect(advance + r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight());
                gp.append(r2, false);
                ++j;
            }
            advance += gv.getLogicalBounds().getWidth();
            ++i;
        }
        return gp;
    }

    public Rectangle2D getBounds() {
        if (this.boundsCache == null) {
            this.boundsCache = this.getOutline(new AffineTransform()).getBounds();
        }
        return this.boundsCache;
    }

    public float[] getCaretInfo(TextHitInfo hit) {
        return this.getCaretInfo(hit, this.getNaturalBounds());
    }

    public float[] getCaretInfo(TextHitInfo hit, Rectangle2D bounds) {
        float[] info = new float[2];
        int index = hit.getCharIndex();
        boolean leading = hit.isLeadingEdge();
        if (index >= this.length) {
            info[0] = this.getAdvance();
            info[1] = 0.0f;
        } else {
            Run run;
            if (index < 0) {
                run = this.runs[0];
                index = 0;
                leading = true;
            } else {
                run = this.findRunAtIndex(index);
            }
            int glyphIndex = index - run.runStart;
            Shape glyphBounds = run.glyphVector.getGlyphLogicalBounds(glyphIndex);
            Rectangle2D glyphRect = glyphBounds.getBounds2D();
            info[0] = this.isVertical() ? (leading ? (float)glyphRect.getMinY() : (float)glyphRect.getMaxY()) : (leading ? (float)glyphRect.getMinX() : (float)glyphRect.getMaxX());
            info[0] = info[0] + run.location;
            info[1] = run.font.getItalicAngle();
        }
        return info;
    }

    public Shape getCaretShape(TextHitInfo hit) {
        return this.getCaretShape(hit, this.getBounds());
    }

    public Shape getCaretShape(TextHitInfo hit, Rectangle2D bounds) {
        float[] info = this.getCaretInfo(hit);
        float x1 = info[0];
        float y1 = (float)bounds.getMinY();
        float x2 = info[0];
        float y2 = (float)bounds.getMaxY();
        if (info[1] != 0.0f) {
            x1 -= y1 * info[1];
            x2 -= y2 * info[1];
        }
        GeneralPath path = new GeneralPath(0, 2);
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        return path;
    }

    public Shape[] getCaretShapes(int offset) {
        return this.getCaretShapes(offset, this.getNaturalBounds());
    }

    public Shape[] getCaretShapes(int offset, Rectangle2D bounds) {
        return this.getCaretShapes(offset, bounds, DEFAULT_CARET_POLICY);
    }

    public Shape[] getCaretShapes(int offset, Rectangle2D bounds, CaretPolicy policy) {
        TextHitInfo hit2;
        int caretHit2;
        Shape[] carets = new Shape[2];
        TextHitInfo hit1 = TextHitInfo.afterOffset(offset);
        int caretHit1 = this.hitToCaret(hit1);
        if (caretHit1 == (caretHit2 = this.hitToCaret(hit2 = hit1.getOtherHit()))) {
            carets[0] = this.getCaretShape(hit1);
            carets[1] = null;
        } else {
            Shape caret1 = this.getCaretShape(hit1);
            Shape caret2 = this.getCaretShape(hit2);
            TextHitInfo strong = policy.getStrongCaret(hit1, hit2, this);
            if (strong == hit1) {
                carets[0] = caret1;
                carets[1] = caret2;
            } else {
                carets[0] = caret2;
                carets[1] = caret1;
            }
        }
        return carets;
    }

    public int getCharacterCount() {
        return this.length;
    }

    public byte getCharacterLevel(int index) {
        byte level = this.bidi == null ? (byte)0 : (byte)this.bidi.getLevelAt(index);
        return level;
    }

    public float getDescent() {
        return this.lm.getDescent();
    }

    public TextLayout getJustifiedLayout(float justificationWidth) {
        TextLayout newLayout = (TextLayout)this.clone();
        if (this.hasWhitespace) {
            newLayout.handleJustify(justificationWidth);
        }
        return newLayout;
    }

    public float getLeading() {
        return this.lm.getLeading();
    }

    public Shape getLogicalHighlightShape(int firstEndpoint, int secondEndpoint) {
        return this.getLogicalHighlightShape(firstEndpoint, secondEndpoint, this.getBounds());
    }

    public Shape getLogicalHighlightShape(int firstEndpoint, int secondEndpoint, Rectangle2D bounds) {
        if (secondEndpoint - firstEndpoint <= 0) {
            return new Rectangle2D.Float();
        }
        if (firstEndpoint < 0 || secondEndpoint > this.getCharacterCount()) {
            return new Rectangle2D.Float();
        }
        Rectangle2D r = null;
        int ri = this.charIndices[firstEndpoint][0];
        int gi = this.charIndices[firstEndpoint][1];
        int i = 0;
        while (i < ri) {
            this.runs[i].glyphVector.getLogicalBounds().getWidth();
            ++i;
        }
        i = ri;
        while (i <= this.charIndices[secondEndpoint - 1][0]) {
            Run run = this.runs[i];
            GlyphVector gv = run.glyphVector;
            int dg = i == this.charIndices[secondEndpoint - 1][0] ? this.charIndices[secondEndpoint - 1][1] : gv.getNumGlyphs() - 1;
            while (gi <= dg) {
                Rectangle2D r2 = gv.getGlyphLogicalBounds(gi).getBounds2D();
                r = r == null ? r2 : r.createUnion(r2);
                ++gi;
            }
            gi = 0;
            gv.getLogicalBounds().getWidth();
            ++i;
        }
        return r;
    }

    public int[] getLogicalRangesForVisualSelection(TextHitInfo firstEndpoint, TextHitInfo secondEndpoint) {
        this.checkHitInfo(firstEndpoint);
        this.checkHitInfo(secondEndpoint);
        int start = this.hitToCaret(firstEndpoint);
        int end = this.hitToCaret(secondEndpoint);
        if (start > end) {
            int temp = start;
            start = end;
            end = temp;
        }
        boolean[] include = new boolean[this.length];
        int i = start;
        while (i < end) {
            include[this.visualToLogical[i]] = true;
            ++i;
        }
        int numRuns = 0;
        boolean in = false;
        int i2 = 0;
        while (i2 < this.length) {
            if (include[i2] != in) {
                boolean bl = in = !in;
                if (in) {
                    ++numRuns;
                }
            }
            ++i2;
        }
        int[] ranges = new int[numRuns * 2];
        int index = 0;
        in = false;
        int i3 = 0;
        while (i3 < this.length) {
            if (include[i3] != in) {
                ranges[index] = i3;
                ++index;
                in = !in;
            }
            ++i3;
        }
        if (in) {
            ranges[index] = this.length;
        }
        return ranges;
    }

    public TextHitInfo getNextLeftHit(int offset) {
        return this.getNextLeftHit(offset, DEFAULT_CARET_POLICY);
    }

    public TextHitInfo getNextLeftHit(int offset, CaretPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("Null policy not allowed");
        }
        if (offset < 0 || offset > this.length) {
            throw new IllegalArgumentException("Offset out of bounds");
        }
        TextHitInfo hit1 = TextHitInfo.afterOffset(offset);
        TextHitInfo hit2 = hit1.getOtherHit();
        TextHitInfo strong = policy.getStrongCaret(hit1, hit2, this);
        TextHitInfo next = this.getNextLeftHit(strong);
        TextHitInfo ret = null;
        if (next != null) {
            TextHitInfo next2 = this.getVisualOtherHit(next);
            ret = policy.getStrongCaret(next2, next, this);
        }
        return ret;
    }

    public TextHitInfo getNextLeftHit(TextHitInfo hit) {
        this.checkHitInfo(hit);
        int index = this.hitToCaret(hit);
        TextHitInfo next = null;
        if (index != 0) {
            next = this.caretToHit(--index);
        }
        return next;
    }

    public TextHitInfo getNextRightHit(int offset) {
        return this.getNextRightHit(offset, DEFAULT_CARET_POLICY);
    }

    public TextHitInfo getNextRightHit(int offset, CaretPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("Null policy not allowed");
        }
        if (offset < 0 || offset > this.length) {
            throw new IllegalArgumentException("Offset out of bounds");
        }
        TextHitInfo hit1 = TextHitInfo.afterOffset(offset);
        TextHitInfo hit2 = hit1.getOtherHit();
        TextHitInfo next = this.getNextRightHit(policy.getStrongCaret(hit1, hit2, this));
        TextHitInfo ret = null;
        if (next != null) {
            TextHitInfo next2 = this.getVisualOtherHit(next);
            ret = policy.getStrongCaret(next2, next, this);
        }
        return ret;
    }

    public TextHitInfo getNextRightHit(TextHitInfo hit) {
        this.checkHitInfo(hit);
        int index = this.hitToCaret(hit);
        TextHitInfo next = null;
        if (index < this.length) {
            next = this.caretToHit(++index);
        }
        return next;
    }

    public Shape getOutline(AffineTransform tx) {
        float x = 0.0f;
        GeneralPath gp = new GeneralPath();
        int i = 0;
        while (i < this.runs.length) {
            GlyphVector gv = this.runs[i].glyphVector;
            gp.append(gv.getOutline(x, 0.0f), false);
            Rectangle2D r = gv.getLogicalBounds();
            x = (float)((double)x + r.getWidth());
            ++i;
        }
        if (tx != null) {
            gp.transform(tx);
        }
        return gp;
    }

    public float getVisibleAdvance() {
        float totalAdvance = 0.0f;
        if (this.runs.length <= 0) {
            return 0.0f;
        }
        if (!Character.isWhitespace(this.string[this.offset + this.length - 1])) {
            return this.getAdvance();
        }
        int i = 0;
        while (i < this.runs.length - 1) {
            totalAdvance = (float)((double)totalAdvance + this.runs[i].glyphVector.getLogicalBounds().getWidth());
            ++i;
        }
        int lastRun = this.runs[this.runs.length - 1].runStart;
        int j = this.length - 1;
        while (j >= lastRun && Character.isWhitespace(this.string[j])) {
            --j;
        }
        if (j < lastRun) {
            return totalAdvance;
        }
        int lastNonWSChar = j - lastRun;
        j = 0;
        while (this.runs[this.runs.length - 1].glyphVector.getGlyphCharIndex(j) <= lastNonWSChar) {
            totalAdvance = (float)((double)totalAdvance + this.runs[this.runs.length - 1].glyphVector.getGlyphLogicalBounds(j).getBounds2D().getWidth());
            ++j;
        }
        return totalAdvance;
    }

    public Shape getVisualHighlightShape(TextHitInfo firstEndpoint, TextHitInfo secondEndpoint) {
        return this.getVisualHighlightShape(firstEndpoint, secondEndpoint, this.getBounds());
    }

    public Shape getVisualHighlightShape(TextHitInfo firstEndpoint, TextHitInfo secondEndpoint, Rectangle2D bounds) {
        GeneralPath path = new GeneralPath(0);
        Shape caret1 = this.getCaretShape(firstEndpoint, bounds);
        path.append(caret1, false);
        Shape caret2 = this.getCaretShape(secondEndpoint, bounds);
        path.append(caret2, false);
        int c1 = this.hitToCaret(firstEndpoint);
        int c2 = this.hitToCaret(secondEndpoint);
        if (c1 == 0 || c2 == 0) {
            path.append(this.left(bounds), false);
        }
        if (c1 == this.length || c2 == this.length) {
            path.append(this.right(bounds), false);
        }
        return path.getBounds2D();
    }

    private Shape left(Rectangle2D b) {
        GeneralPath left = new GeneralPath(0);
        left.append(this.getCaretShape(TextHitInfo.beforeOffset(0)), false);
        if (this.isVertical()) {
            float y = (float)b.getMinY();
            left.append(new Line2D.Float((float)b.getMinX(), y, (float)b.getMaxX(), y), false);
        } else {
            float x = (float)b.getMinX();
            left.append(new Line2D.Float(x, (float)b.getMinY(), x, (float)b.getMaxY()), false);
        }
        return left.getBounds2D();
    }

    private Shape right(Rectangle2D b) {
        GeneralPath right = new GeneralPath(0);
        right.append(this.getCaretShape(TextHitInfo.afterOffset(this.length)), false);
        if (this.isVertical()) {
            float y = (float)b.getMaxY();
            right.append(new Line2D.Float((float)b.getMinX(), y, (float)b.getMaxX(), y), false);
        } else {
            float x = (float)b.getMaxX();
            right.append(new Line2D.Float(x, (float)b.getMinY(), x, (float)b.getMaxY()), false);
        }
        return right.getBounds2D();
    }

    public TextHitInfo getVisualOtherHit(TextHitInfo hit) {
        boolean leading;
        int index;
        this.checkHitInfo(hit);
        int hitIndex = hit.getCharIndex();
        if (hitIndex == -1 || hitIndex == this.length) {
            int visual = this.isLeftToRight() == (hitIndex == -1) ? 0 : this.length - 1;
            index = this.visualToLogical[visual];
            leading = this.isLeftToRight() == (hitIndex == -1) ? this.isCharacterLTR(index) : !this.isCharacterLTR(index);
        } else {
            boolean b;
            int visual = this.logicalToVisual[hitIndex];
            if (this.isCharacterLTR(hitIndex) == hit.isLeadingEdge()) {
                --visual;
                b = false;
            } else {
                ++visual;
                b = true;
            }
            if (visual >= 0 && visual < this.length) {
                index = this.visualToLogical[visual];
                leading = b == this.isLeftToRight();
            } else {
                index = b == this.isLeftToRight() ? this.length : -1;
                leading = index == this.length;
            }
        }
        return leading ? TextHitInfo.leading(index) : TextHitInfo.trailing(index);
    }

    protected void handleJustify(float justificationWidth) {
        double deltaW = justificationWidth - this.getVisibleAdvance();
        int nglyphs = 0;
        int lastNWS = this.offset + this.length - 1;
        while (Character.isWhitespace(this.string[lastNWS])) {
            --lastNWS;
        }
        int[] wsglyphs = new int[this.length * 10];
        int run = 0;
        while (run < this.runs.length) {
            Run current = this.runs[run];
            int i = 0;
            while (i < current.glyphVector.getNumGlyphs()) {
                int cindex = current.runStart + current.glyphVector.getGlyphCharIndex(i);
                if (Character.isWhitespace(this.string[cindex])) {
                    wsglyphs[nglyphs * 2] = run;
                    wsglyphs[nglyphs * 2 + 1] = i;
                    ++nglyphs;
                }
                ++i;
            }
            ++run;
        }
        deltaW /= (double)nglyphs;
        double w = 0.0;
        int cws = 0;
        int run2 = 0;
        while (run2 < this.runs.length) {
            Run current = this.runs[run2];
            int i = 0;
            while (i < current.glyphVector.getNumGlyphs()) {
                if (wsglyphs[cws * 2] == run2 && wsglyphs[cws * 2 + 1] == i) {
                    ++cws;
                    w += deltaW;
                }
                Point2D p = current.glyphVector.getGlyphPosition(i);
                p.setLocation(p.getX() + w, p.getY());
                current.glyphVector.setGlyphPosition(i, p);
                ++i;
            }
            ++run2;
        }
    }

    public TextHitInfo hitTestChar(float x, float y) {
        return this.hitTestChar(x, y, this.getNaturalBounds());
    }

    public TextHitInfo hitTestChar(float x, float y, Rectangle2D bounds) {
        TextHitInfo hitInfo;
        block18: {
            block17: {
                if (this.isVertical()) {
                    if ((double)y < bounds.getMinY()) {
                        return TextHitInfo.leading(0);
                    }
                    if ((double)y > bounds.getMaxY()) {
                        return TextHitInfo.trailing(this.getCharacterCount() - 1);
                    }
                } else {
                    if ((double)x < bounds.getMinX()) {
                        return TextHitInfo.leading(0);
                    }
                    if ((double)x > bounds.getMaxX()) {
                        return TextHitInfo.trailing(this.getCharacterCount() - 1);
                    }
                }
                hitInfo = null;
                if (!this.isVertical()) break block17;
                int numRuns = this.runs.length;
                Run hitRun = null;
                int i = 0;
                while (i < numRuns && hitRun == null) {
                    Run run = this.runs[i];
                    Rectangle2D lBounds = run.glyphVector.getLogicalBounds();
                    if (lBounds.getMinY() + (double)run.location <= (double)y && lBounds.getMaxY() + (double)run.location >= (double)y) {
                        hitRun = run;
                    }
                    ++i;
                }
                if (hitRun == null) break block18;
                GlyphVector gv = hitRun.glyphVector;
                int i2 = hitRun.runStart;
                while (i2 < hitRun.runEnd && hitInfo == null) {
                    int gi = i2 - hitRun.runStart;
                    Rectangle2D lBounds = gv.getGlyphLogicalBounds(gi).getBounds2D();
                    if (lBounds.getMinY() + (double)hitRun.location <= (double)y && lBounds.getMaxY() + (double)hitRun.location >= (double)y) {
                        boolean leading = true;
                        if (lBounds.getCenterY() + (double)hitRun.location <= (double)y) {
                            leading = false;
                        }
                        hitInfo = leading ? TextHitInfo.leading(i2) : TextHitInfo.trailing(i2);
                    }
                    ++i2;
                }
                break block18;
            }
            int numRuns = this.runs.length;
            Run hitRun = null;
            int i = 0;
            while (i < numRuns && hitRun == null) {
                Run run = this.runs[i];
                Rectangle2D lBounds = run.glyphVector.getLogicalBounds();
                if (lBounds.getMinX() + (double)run.location <= (double)x && lBounds.getMaxX() + (double)run.location >= (double)x) {
                    hitRun = run;
                }
                ++i;
            }
            if (hitRun != null) {
                GlyphVector gv = hitRun.glyphVector;
                int i3 = hitRun.runStart;
                while (i3 < hitRun.runEnd && hitInfo == null) {
                    int gi = i3 - hitRun.runStart;
                    Rectangle2D lBounds = gv.getGlyphLogicalBounds(gi).getBounds2D();
                    if (lBounds.getMinX() + (double)hitRun.location <= (double)x && lBounds.getMaxX() + (double)hitRun.location >= (double)x) {
                        boolean leading = true;
                        if (lBounds.getCenterX() + (double)hitRun.location <= (double)x) {
                            leading = false;
                        }
                        hitInfo = leading ? TextHitInfo.leading(i3) : TextHitInfo.trailing(i3);
                    }
                    ++i3;
                }
            }
        }
        return hitInfo;
    }

    public boolean isLeftToRight() {
        return this.leftToRight;
    }

    public boolean isVertical() {
        return false;
    }

    public int hashCode() {
        if (this.hash == 0 && this.runs.length > 0) {
            this.hash = this.runs.length;
            int i = 0;
            while (i < this.runs.length) {
                this.hash ^= this.runs[i].glyphVector.hashCode();
                ++i;
            }
        }
        return this.hash;
    }

    public String toString() {
        return "TextLayout [string:" + new String(this.string, this.offset, this.length) + " Rendercontext:" + this.frc + "]";
    }

    private Rectangle2D getNaturalBounds() {
        if (this.naturalBounds == null) {
            this.naturalBounds = new Rectangle2D.Float(0.0f, -this.getAscent(), this.getAdvance(), this.getAscent() + this.getDescent());
        }
        return this.naturalBounds;
    }

    private void checkHitInfo(TextHitInfo hit) {
        if (hit == null) {
            throw new IllegalArgumentException("Null hit info not allowed");
        }
        int index = hit.getInsertionIndex();
        if (index < 0 || index > this.length) {
            throw new IllegalArgumentException("Hit index out of range");
        }
    }

    private int hitToCaret(TextHitInfo hit) {
        int ret;
        int index = hit.getCharIndex();
        if (index < 0) {
            ret = this.isLeftToRight() ? 0 : this.length;
        } else if (index >= this.length) {
            ret = this.isLeftToRight() ? this.length : 0;
        } else {
            ret = this.logicalToVisual[index];
            if (hit.isLeadingEdge() != this.isCharacterLTR(index)) {
                ++ret;
            }
        }
        return ret;
    }

    private TextHitInfo caretToHit(int index) {
        int logical;
        boolean leading;
        TextHitInfo hit = index == 0 || index == this.length ? (index == this.length == this.isLeftToRight() ? TextHitInfo.leading(this.length) : TextHitInfo.trailing(-1)) : ((leading = this.isCharacterLTR(logical = this.visualToLogical[index])) ? TextHitInfo.leading(logical) : TextHitInfo.trailing(logical));
        return hit;
    }

    private boolean isCharacterLTR(int index) {
        byte level = this.getCharacterLevel(index);
        return (level & 1) == 0;
    }

    private Run findRunAtIndex(int index) {
        Run found = null;
        int i = 0;
        while (i < this.runs.length && found == null) {
            Run run = this.runs[i];
            if (run.runStart <= index && run.runEnd > index) {
                found = run;
            }
            ++i;
        }
        return found;
    }

    private void layoutRuns() {
        float loc = 0.0f;
        int i = 0;
        while (i < this.runs.length) {
            this.runs[i].location = loc;
            Rectangle2D bounds = this.runs[i].glyphVector.getLogicalBounds();
            loc = (float)((double)loc + (this.isVertical() ? bounds.getHeight() : bounds.getWidth()));
            ++i;
        }
    }

    public static class CaretPolicy {
        public TextHitInfo getStrongCaret(TextHitInfo hit1, TextHitInfo hit2, TextLayout layout) {
            byte l2;
            byte l1 = layout.getCharacterLevel(hit1.getCharIndex());
            TextHitInfo strong = l1 == (l2 = layout.getCharacterLevel(hit2.getCharIndex())) ? (hit2.isLeadingEdge() && !hit1.isLeadingEdge() ? hit2 : hit1) : (l1 < l2 ? hit1 : hit2);
            return strong;
        }
    }

    private class Run {
        GlyphVector glyphVector;
        Font font;
        int runStart;
        int runEnd;
        float location;

        Run(GlyphVector gv, Font f, int start, int end) {
            this.glyphVector = gv;
            this.font = f;
            this.runStart = start;
            this.runEnd = end;
        }

        boolean isLeftToRight() {
            return (this.glyphVector.getLayoutFlags() & 4) == 0;
        }
    }
}

