/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.undo;

import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public class UndoableEditSupport {
    protected int updateLevel;
    protected CompoundEdit compoundEdit;
    protected Vector<UndoableEditListener> listeners = new Vector();
    protected Object realSource;

    public UndoableEditSupport() {
        this.realSource = this;
    }

    public UndoableEditSupport(Object realSource) {
        if (realSource == null) {
            realSource = this;
        }
        this.realSource = realSource;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " updateLevel: " + this.updateLevel + " listeners: " + this.listeners + " compoundEdit: " + this.compoundEdit;
    }

    public synchronized void addUndoableEditListener(UndoableEditListener val) {
        this.listeners.add(val);
    }

    public synchronized void removeUndoableEditListener(UndoableEditListener val) {
        this.listeners.removeElement(val);
    }

    public synchronized UndoableEditListener[] getUndoableEditListeners() {
        UndoableEditListener[] result = new UndoableEditListener[this.listeners.size()];
        return this.listeners.toArray((S[])result);
    }

    protected void _postEdit(UndoableEdit edit) {
        if (this.listeners.isEmpty()) {
            return;
        }
        UndoableEditEvent event = new UndoableEditEvent(this.realSource, edit);
        Iterator iter = ((Vector)this.listeners.clone()).iterator();
        while (iter.hasNext()) {
            ((UndoableEditListener)iter.next()).undoableEditHappened(event);
        }
    }

    public synchronized void postEdit(UndoableEdit edit) {
        if (this.compoundEdit != null) {
            this.compoundEdit.addEdit(edit);
        } else {
            this._postEdit(edit);
        }
    }

    public int getUpdateLevel() {
        return this.updateLevel;
    }

    public synchronized void beginUpdate() {
        if (this.compoundEdit == null) {
            this.compoundEdit = this.createCompoundEdit();
        }
        ++this.updateLevel;
    }

    protected CompoundEdit createCompoundEdit() {
        return new CompoundEdit();
    }

    public synchronized void endUpdate() {
        if (this.updateLevel == 0) {
            throw new IllegalStateException();
        }
        if (--this.updateLevel > 0) {
            return;
        }
        this.compoundEdit.end();
        this._postEdit(this.compoundEdit);
        this.compoundEdit = null;
    }
}

