/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.annotation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationTypeMismatchException;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationInvocationHandler
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 6182022883658399397L;
    private final Class<? extends Annotation> type;
    private final Map<String, ?> memberValues;

    public AnnotationInvocationHandler(Class<? extends Annotation> type, Map memberValues) {
        this.type = type;
        this.memberValues = memberValues;
    }

    public static Annotation create(Class<? extends Annotation> type, Map memberValues) {
        Method[] methodArray = type.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            String name = m.getName();
            if (!memberValues.containsKey(name)) {
                memberValues.put(name, m.getDefaultValue());
            }
            ++n2;
        }
        AnnotationInvocationHandler handler = new AnnotationInvocationHandler(type, memberValues);
        return (Annotation)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, handler);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object proxy, Object other) {
        if (!this.type.isInstance(other)) return false;
        try {
            Method[] methods = this.type.getDeclaredMethods();
            if (methods.length != this.memberValues.size()) return false;
            int i = 0;
            while (true) {
                if (i >= methods.length) {
                    return true;
                }
                methods[i].getName();
                Object val = methods[i].invoke(other, null);
                Object thisVal = this.invoke(proxy, methods[i], null);
                if (!AnnotationInvocationHandler.deepEquals(thisVal, val)) {
                    return false;
                }
                ++i;
            }
        }
        catch (Throwable throwable) {}
        return false;
    }

    private static boolean deepEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1 instanceof boolean[] && o2 instanceof boolean[]) {
            return Arrays.equals((boolean[])o1, (boolean[])o2);
        }
        if (o1 instanceof byte[] && o2 instanceof byte[]) {
            return Arrays.equals((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof char[] && o2 instanceof char[]) {
            return Arrays.equals((char[])o1, (char[])o2);
        }
        if (o1 instanceof short[] && o2 instanceof short[]) {
            return Arrays.equals((short[])o1, (short[])o2);
        }
        if (o1 instanceof int[] && o2 instanceof int[]) {
            return Arrays.equals((int[])o1, (int[])o2);
        }
        if (o1 instanceof float[] && o2 instanceof float[]) {
            return Arrays.equals((float[])o1, (float[])o2);
        }
        if (o1 instanceof long[] && o2 instanceof long[]) {
            return Arrays.equals((long[])o1, (long[])o2);
        }
        if (o1 instanceof double[] && o2 instanceof double[]) {
            return Arrays.equals((double[])o1, (double[])o2);
        }
        if (o1 instanceof Object[] && o2 instanceof Object[]) {
            return Arrays.equals((Object[])o1, (Object[])o2);
        }
        return o1.equals(o2);
    }

    private static int deepHashCode(Object obj) {
        if (obj instanceof boolean[]) {
            return Arrays.hashCode((boolean[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.hashCode((byte[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.hashCode((char[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.hashCode((short[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.hashCode((int[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.hashCode((float[])obj);
        }
        if (obj instanceof long[]) {
            return Arrays.hashCode((long[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.hashCode((double[])obj);
        }
        if (obj instanceof Object[]) {
            return Arrays.hashCode((Object[])obj);
        }
        return obj.hashCode();
    }

    public int hashCode() {
        int h = 0;
        for (String key : this.memberValues.keySet()) {
            try {
                Object val = this.invoke(null, this.type.getDeclaredMethod(key, null), null);
                h += AnnotationInvocationHandler.deepHashCode(val) ^ 127 * key.hashCode();
            }
            catch (Throwable throwable) {}
        }
        return h;
    }

    private static String deepToString(Object obj) {
        if (obj instanceof Object[]) {
            return Arrays.toString((Object[])obj);
        }
        return obj.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('@').append(this.type.getName()).append('(');
        String sep = "";
        for (String key : this.memberValues.keySet()) {
            Object val = this.memberValues.get(key);
            sb.append(sep).append((Object)key).append('=').append(AnnotationInvocationHandler.deepToString(val));
            sep = ", ";
        }
        sb.append(')');
        return sb.toString();
    }

    private static Class getBoxedReturnType(Method method) {
        Class<?> returnType = method.getReturnType();
        if (returnType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (returnType == Byte.TYPE) {
            return Byte.class;
        }
        if (returnType == Character.TYPE) {
            return Character.class;
        }
        if (returnType == Short.TYPE) {
            return Short.class;
        }
        if (returnType == Integer.TYPE) {
            return Integer.class;
        }
        if (returnType == Float.TYPE) {
            return Float.class;
        }
        if (returnType == Long.TYPE) {
            return Long.class;
        }
        if (returnType == Double.TYPE) {
            return Double.class;
        }
        return returnType;
    }

    private Object coerce(Object val, Class dstType) throws ArrayStoreException {
        if (!val.getClass().isArray()) {
            return val;
        }
        Object[] srcArray = (Object[])val;
        int len = srcArray.length;
        if (dstType.getComponentType().isPrimitive()) {
            if (dstType == boolean[].class) {
                boolean[] dst = new boolean[len];
                int i = 0;
                while (i < len) {
                    dst[i] = (Boolean)srcArray[i];
                    ++i;
                }
                return dst;
            }
            if (dstType == byte[].class) {
                byte[] dst = new byte[len];
                int i = 0;
                while (i < len) {
                    dst[i] = (Byte)srcArray[i];
                    ++i;
                }
                return dst;
            }
            if (dstType == char[].class) {
                char[] dst = new char[len];
                int i = 0;
                while (i < len) {
                    dst[i] = ((Character)srcArray[i]).charValue();
                    ++i;
                }
                return dst;
            }
            if (dstType == short[].class) {
                short[] dst = new short[len];
                int i = 0;
                while (i < len) {
                    dst[i] = (Short)srcArray[i];
                    ++i;
                }
                return dst;
            }
            if (dstType == int[].class) {
                int[] dst = new int[len];
                int i = 0;
                while (i < len) {
                    dst[i] = (Integer)srcArray[i];
                    ++i;
                }
                return dst;
            }
            if (dstType == long[].class) {
                long[] dst = new long[len];
                int i = 0;
                while (i < len) {
                    dst[i] = (Long)srcArray[i];
                    ++i;
                }
                return dst;
            }
            if (dstType == float[].class) {
                float[] dst = new float[len];
                int i = 0;
                while (i < len) {
                    dst[i] = ((Float)srcArray[i]).floatValue();
                    ++i;
                }
                return dst;
            }
            if (dstType == double[].class) {
                double[] dst = new double[len];
                int i = 0;
                while (i < len) {
                    dst[i] = (Double)srcArray[i];
                    ++i;
                }
                return dst;
            }
        }
        Object dst = Array.newInstance(dstType.getComponentType(), len);
        System.arraycopy(srcArray, 0, dst, 0, len);
        return dst;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName().intern();
        if (args == null || args.length == 0) {
            if (methodName == "toString") {
                return this.toString();
            }
            if (methodName == "hashCode") {
                return this.hashCode();
            }
            if (methodName == "annotationType") {
                return this.type;
            }
            Object val = this.memberValues.get(methodName);
            if (val == null) {
                throw new IncompleteAnnotationException(this.type, methodName);
            }
            try {
                if (val.getClass().isArray()) {
                    val = this.coerce((Object[])val, method.getReturnType());
                }
            }
            catch (ArrayStoreException arrayStoreException) {
                throw new AnnotationTypeMismatchException(method, val.getClass().getName());
            }
            if (!AnnotationInvocationHandler.getBoxedReturnType(method).isInstance(val)) {
                throw new AnnotationTypeMismatchException(method, val.getClass().getName());
            }
            return val;
        }
        if (args.length == 1 && methodName == "equals") {
            return this.equals(proxy, args[0]);
        }
        throw new InternalError("Invalid annotation proxy");
    }
}

