/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Stack;
import javax.swing.text.AbstractWriter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class MinimalHTMLWriter
extends AbstractWriter {
    private StyledDocument doc;
    private Stack tagStack;
    private boolean inFontTag = false;

    public MinimalHTMLWriter(Writer w, StyledDocument doc) {
        super(w, doc);
        this.doc = doc;
        this.tagStack = new Stack();
    }

    public MinimalHTMLWriter(Writer w, StyledDocument doc, int pos, int len) {
        super(w, doc, pos, len);
        this.doc = doc;
        this.tagStack = new Stack();
    }

    protected void startFontTag(String style) throws IOException {
        if (this.inFontTag()) {
            this.endOpenTags();
        }
        this.writeStartTag("<span style=\"" + style + "\">");
        this.inFontTag = true;
    }

    protected boolean inFontTag() {
        return this.inFontTag;
    }

    protected void endFontTag() throws IOException {
        this.writeEndTag("</span>");
        this.inFontTag = false;
    }

    public synchronized void write() throws IOException, BadLocationException {
        this.writeStartTag("<html>");
        this.writeHeader();
        this.writeBody();
        this.writeEndTag("</html>");
    }

    protected void writeStartTag(String tag) throws IOException {
        this.indent();
        this.write(String.valueOf(tag) + '\n');
        this.incrIndent();
    }

    protected void writeEndTag(String endTag) throws IOException {
        this.decrIndent();
        this.indent();
        this.write(String.valueOf(endTag) + '\n');
    }

    protected void writeHeader() throws IOException {
        this.writeStartTag("<head>");
        this.writeStartTag("<style>");
        this.writeStartTag("<!--");
        this.writeStyles();
        this.writeEndTag("-->");
        this.writeEndTag("</style>");
        this.writeEndTag("</head>");
    }

    protected void writeStartParagraph(Element elem) throws IOException {
        this.indent();
        this.write("<p class=default>\n");
        this.incrIndent();
    }

    protected void writeEndParagraph() throws IOException {
        this.endOpenTags();
        this.writeEndTag("</p>");
    }

    protected void writeBody() throws IOException, BadLocationException {
        this.writeStartTag("<body>");
        ElementIterator ei = this.getElementIterator();
        Element e = ei.first();
        boolean inParagraph = false;
        do {
            boolean hasNL;
            if (!e.isLeaf()) continue;
            boolean bl = hasNL = this.getText(e).indexOf(10) != -1;
            if (!inParagraph && this.hasText(e)) {
                this.writeStartParagraph(e);
                inParagraph = true;
            }
            if (this.hasText(e)) {
                this.writeContent(e, true);
            }
            if (hasNL && inParagraph) {
                this.writeEndParagraph();
                inParagraph = false;
                continue;
            }
            this.endOpenTags();
        } while ((e = ei.next()) != null);
        this.writeEndTag("</body>");
    }

    protected void text(Element elem) throws IOException, BadLocationException {
        this.write(this.getText(elem).trim());
    }

    protected void writeHTMLTags(AttributeSet attr) throws IOException {
        if (attr.getAttribute(StyleConstants.Bold) != null && ((Boolean)attr.getAttribute(StyleConstants.Bold)).booleanValue()) {
            this.write("<b>");
            this.tagStack.push("</b>");
        }
        if (attr.getAttribute(StyleConstants.Italic) != null && ((Boolean)attr.getAttribute(StyleConstants.Italic)).booleanValue()) {
            this.write("<i>");
            this.tagStack.push("</i>");
        }
        if (attr.getAttribute(StyleConstants.Underline) != null && ((Boolean)attr.getAttribute(StyleConstants.Underline)).booleanValue()) {
            this.write("<u>");
            this.tagStack.push("</u>");
        }
    }

    protected boolean isText(Element elem) {
        return elem.getEndOffset() != elem.getStartOffset();
    }

    protected void writeContent(Element elem, boolean needsIndenting) throws IOException, BadLocationException {
        this.writeNonHTMLAttributes(elem.getAttributes());
        if (needsIndenting) {
            this.indent();
        }
        this.writeHTMLTags(elem.getAttributes());
        if (this.isText(elem)) {
            this.text(elem);
        } else {
            this.writeLeaf(elem);
        }
        this.endOpenTags();
    }

    protected void writeLeaf(Element e) throws IOException {
        if (e.getName().equals("icon")) {
            this.writeImage(e);
        } else {
            this.writeComponent(e);
        }
    }

    protected void writeNonHTMLAttributes(AttributeSet attr) throws IOException {
        String style = "";
        if (StyleConstants.getForeground(attr) != null) {
            style = String.valueOf(style) + "color: " + this.getColor(StyleConstants.getForeground(attr)) + "; ";
        }
        style = String.valueOf(style) + "font-size: " + StyleConstants.getFontSize(attr) + "pt; ";
        style = String.valueOf(style) + "font-family: " + StyleConstants.getFontFamily(attr);
        this.startFontTag(style);
    }

    protected void writeStyles() throws IOException {
        if (this.doc instanceof DefaultStyledDocument) {
            Enumeration<?> styles = ((DefaultStyledDocument)this.doc).getStyleNames();
            while (styles.hasMoreElements()) {
                this.writeStyle(this.doc.getStyle((String)styles.nextElement()));
            }
        } else {
            Style s = this.doc.getStyle("default");
            if (s != null) {
                this.writeStyle(s);
            }
        }
    }

    protected void writeAttributes(AttributeSet attr) throws IOException {
        Enumeration<?> attribs = attr.getAttributeNames();
        while (attribs.hasMoreElements()) {
            Object attribName = attribs.nextElement();
            String name = attribName.toString();
            String output = this.getAttribute(name, attr.getAttribute(attribName));
            if (output == null) continue;
            this.indent();
            this.write(String.valueOf(output) + '\n');
        }
    }

    protected void writeComponent(Element elem) throws IOException {
    }

    protected void writeImage(Element elem) throws IOException {
    }

    private String getAttribute(String name, Object a) throws IOException {
        if (name.equals("foreground")) {
            return "foreground:" + this.getColor((Color)a) + ";";
        }
        if (name.equals("background")) {
            return "background:" + this.getColor((Color)a) + ";";
        }
        if (name.equals("italic")) {
            return "italic:" + ((Boolean)a != false ? "italic;" : ";");
        }
        if (name.equals("bold")) {
            return "bold:" + ((Boolean)a != false ? "bold;" : "normal;");
        }
        if (name.equals("family")) {
            return "family:" + a + ";";
        }
        if (name.equals("size")) {
            int size = (Integer)a;
            int htmlSize = size > 24 ? 7 : (size > 18 ? 6 : (size > 14 ? 5 : (size > 12 ? 4 : (size > 10 ? 3 : (size > 8 ? 2 : 1)))));
            return "size:" + htmlSize + ";";
        }
        return null;
    }

    private String getColor(Color c) {
        String r = "00" + Integer.toHexString(c.getRed());
        r = r.substring(r.length() - 2);
        String g = "00" + Integer.toHexString(c.getGreen());
        g = g.substring(g.length() - 2);
        String b = "00" + Integer.toHexString(c.getBlue());
        b = b.substring(b.length() - 2);
        return "#" + r + g + b;
    }

    private void endOpenTags() throws IOException {
        while (!this.tagStack.empty()) {
            this.write((String)this.tagStack.pop());
        }
        if (this.inFontTag()) {
            this.write("\n");
            this.endFontTag();
        }
    }

    private void writeStyle(Style s) throws IOException {
        if (s == null) {
            return;
        }
        this.writeStartTag("p." + s.getName() + " {");
        this.writeAttributes(s);
        this.writeEndTag("}");
    }

    private boolean hasText(Element e) throws BadLocationException {
        return this.getText(e).trim().length() > 0;
    }
}

