/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import gnu.classpath.NotImplementedException;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultButtonModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.GapContent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.html.Option;
import javax.swing.text.html.ResetablePlainDocument;
import javax.swing.text.html.ResetableToggleButtonModel;
import javax.swing.text.html.SelectComboBoxModel;
import javax.swing.text.html.SelectListModel;
import javax.swing.text.html.StyleSheet;

public class HTMLDocument
extends DefaultStyledDocument {
    public static final String AdditionalComments = "AdditionalComments";
    URL baseURL = null;
    boolean preservesUnknownTags = true;
    int tokenThreshold = Integer.MAX_VALUE;
    HTMLEditorKit.Parser parser;
    private boolean frameDocument;
    String baseTarget;

    public HTMLDocument() {
        this((AbstractDocument.Content)new GapContent(4096), new StyleSheet());
    }

    public HTMLDocument(StyleSheet styles) {
        this((AbstractDocument.Content)new GapContent(4096), styles);
    }

    public HTMLDocument(AbstractDocument.Content c, StyleSheet styles) {
        super(c, styles);
    }

    public StyleSheet getStyleSheet() {
        return (StyleSheet)this.getAttributeContext();
    }

    protected AbstractDocument.AbstractElement createDefaultRoot() {
        AbstractDocument.AttributeContext ctx = this.getAttributeContext();
        AttributeSet atts = ctx.getEmptySet();
        atts = ctx.addAttribute(atts, StyleConstants.NameAttribute, HTML.Tag.HTML);
        AbstractDocument.BranchElement html = (AbstractDocument.BranchElement)this.createBranchElement(null, atts);
        atts = ctx.getEmptySet();
        atts = ctx.addAttribute(atts, StyleConstants.NameAttribute, HTML.Tag.BODY);
        AbstractDocument.BranchElement body = (AbstractDocument.BranchElement)this.createBranchElement(html, atts);
        html.replace(0, 0, new Element[]{body});
        atts = ctx.getEmptySet();
        atts = ctx.addAttribute(atts, StyleConstants.NameAttribute, HTML.Tag.P);
        AbstractDocument.BranchElement p = (AbstractDocument.BranchElement)this.createBranchElement(body, atts);
        body.replace(0, 0, new Element[]{p});
        atts = ctx.getEmptySet();
        atts = ctx.addAttribute(atts, StyleConstants.NameAttribute, HTML.Tag.CONTENT);
        Element leaf = this.createLeafElement(p, atts, 0, 1);
        p.replace(0, 0, new Element[]{leaf});
        return html;
    }

    protected Element createLeafElement(Element parent, AttributeSet a, int p0, int p1) {
        return new RunElement(parent, a, p0, p1);
    }

    protected Element createBranchElement(Element parent, AttributeSet a) {
        return new BlockElement(parent, a);
    }

    public HTMLEditorKit.Parser getParser() {
        return this.parser;
    }

    public void setParser(HTMLEditorKit.Parser p) {
        this.parser = p;
    }

    public void setTokenThreshold(int n) {
        this.tokenThreshold = n;
    }

    public int getTokenThreshold() {
        return this.tokenThreshold;
    }

    public URL getBase() {
        return this.baseURL;
    }

    public void setBase(URL u) {
        this.baseURL = u;
        this.getStyleSheet().setBase(u);
    }

    public boolean getPreservesUnknownTags() {
        return this.preservesUnknownTags;
    }

    public void setPreservesUnknownTags(boolean preservesTags) {
        this.preservesUnknownTags = preservesTags;
    }

    public void processHTMLFrameHyperlinkEvent(HTMLFrameHyperlinkEvent event) {
        String target = event.getTarget();
        Element el = event.getSourceElement();
        URL url = event.getURL();
        if (target.equals("_self")) {
            this.updateFrame(el, url);
        } else if (target.equals("_parent")) {
            this.updateFrameSet(el.getParentElement(), url);
        } else {
            Element targetFrame = this.findFrame(target);
            if (targetFrame != null) {
                this.updateFrame(targetFrame, url);
            }
        }
    }

    private Element findFrame(String target) {
        ElementIterator i = new ElementIterator(this);
        Element next = null;
        while ((next = i.next()) != null) {
            String name;
            AttributeSet atts = next.getAttributes();
            if (atts.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.FRAME && (name = (String)atts.getAttribute(HTML.Attribute.NAME)) != null && name.equals(target)) break;
        }
        return next;
    }

    private void updateFrame(Element el, URL url) {
        try {
            this.writeLock();
            AbstractDocument.DefaultDocumentEvent ev = new AbstractDocument.DefaultDocumentEvent(el.getStartOffset(), 1, DocumentEvent.EventType.CHANGE);
            AttributeSet elAtts = el.getAttributes();
            AttributeSet copy = elAtts.copyAttributes();
            MutableAttributeSet matts = (MutableAttributeSet)elAtts;
            ev.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(el, copy, false));
            matts.removeAttribute(HTML.Attribute.SRC);
            matts.addAttribute(HTML.Attribute.SRC, url.toString());
            ev.end();
            this.fireChangedUpdate(ev);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, ev));
        }
        finally {
            this.writeUnlock();
        }
    }

    private void updateFrameSet(Element el, URL url) {
        el.getStartOffset();
        el.getEndOffset();
        StringBuilder html = new StringBuilder();
        html.append("<frame");
        if (url != null) {
            html.append(" src=\"");
            html.append(url.toString());
            html.append("\"");
        }
        html.append('>');
        if (this.getParser() == null) {
            this.setParser(new HTMLEditorKit().getParser());
        }
        try {
            this.setOuterHTML(el, html.toString());
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public Iterator getIterator(HTML.Tag t) {
        return new LeafIterator(t, this);
    }

    public HTMLEditorKit.ParserCallback getReader(int pos) {
        return new HTMLReader(pos);
    }

    public HTMLEditorKit.ParserCallback getReader(int pos, int popDepth, int pushDepth, HTML.Tag insertTag) {
        return new HTMLReader(pos, popDepth, pushDepth, insertTag);
    }

    public HTMLEditorKit.ParserCallback getInsertingReader(int pos, int popDepth, int pushDepth, HTML.Tag insertTag, Element parent) throws IllegalStateException {
        if (this.parser == null) {
            throw new IllegalStateException("Parser has not been set");
        }
        HTMLReader reader = new HTMLReader(this, pos, popDepth, pushDepth, insertTag){

            public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                if (t != HTML.Tag.BODY) {
                    super.handleStartTag(t, a, pos);
                }
            }

            public void handleEndTag(HTML.Tag t, int pos) {
                if (t != HTML.Tag.BODY) {
                    super.handleEndTag(t, pos);
                }
            }
        };
        return reader;
    }

    public Element getElement(Element e, Object attribute, Object value) {
        if (e != null) {
            if (e.getAttributes().containsAttribute(attribute, value)) {
                return e;
            }
            int count = e.getElementCount();
            int j = 0;
            while (j < count) {
                Element child = e.getElement(j);
                if (child.getAttributes().containsAttribute(attribute, value)) {
                    return child;
                }
                Element grandChild = this.getElement(child, attribute, value);
                if (grandChild != null) {
                    return grandChild;
                }
                ++j;
            }
        }
        return null;
    }

    public Element getElement(String attrId) {
        return this.getElement(this.getDefaultRootElement(), HTML.Attribute.ID, attrId);
    }

    public void setInnerHTML(Element elem, String htmlText) throws BadLocationException, IOException {
        if (elem.isLeaf()) {
            throw new IllegalArgumentException("Element is a leaf");
        }
        int start = elem.getStartOffset();
        int end = elem.getEndOffset();
        HTMLEditorKit.ParserCallback reader = this.getInsertingReader(end, 0, 0, HTML.Tag.BODY, elem);
        this.getParser().parse(new StringReader(htmlText), reader, true);
        this.remove(start, end - start);
    }

    public void setOuterHTML(Element elem, String htmlText) throws BadLocationException, IOException {
        int start = elem.getStartOffset();
        int end = elem.getEndOffset();
        this.remove(start, end - start);
        HTMLEditorKit.ParserCallback reader = this.getInsertingReader(start, 0, 0, HTML.Tag.BODY, elem);
        this.getParser().parse(new StringReader(htmlText), reader, true);
    }

    public void insertBeforeStart(Element elem, String htmlText) throws BadLocationException, IOException {
        HTMLEditorKit.ParserCallback reader = this.getInsertingReader(elem.getStartOffset(), 0, 0, HTML.Tag.BODY, elem);
        this.getParser().parse(new StringReader(htmlText), reader, true);
    }

    public void insertBeforeEnd(Element elem, String htmlText) throws BadLocationException, IOException {
        HTMLEditorKit.ParserCallback reader = this.getInsertingReader(elem.getEndOffset(), 0, 0, HTML.Tag.BODY, elem);
        this.getParser().parse(new StringReader(htmlText), reader, true);
    }

    public void insertAfterEnd(Element elem, String htmlText) throws BadLocationException, IOException {
        HTMLEditorKit.ParserCallback reader = this.getInsertingReader(elem.getEndOffset(), 0, 0, HTML.Tag.BODY, elem);
        this.getParser().parse(new StringReader(htmlText), reader, true);
    }

    public void insertAfterStart(Element elem, String htmlText) throws BadLocationException, IOException {
        HTMLEditorKit.ParserCallback reader = this.getInsertingReader(elem.getStartOffset(), 0, 0, HTML.Tag.BODY, elem);
        this.getParser().parse(new StringReader(htmlText), reader, true);
    }

    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent evt, AttributeSet att) {
        if (att == null) {
            SimpleAttributeSet sas = new SimpleAttributeSet();
            sas.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
            att = sas;
        }
        super.insertUpdate(evt, att);
    }

    boolean isFrameDocument() {
        return this.frameDocument;
    }

    void setFrameDocument(boolean frameDoc) {
        this.frameDocument = frameDoc;
    }

    String getBaseTarget() {
        return this.baseTarget;
    }

    void updateSpecialClass(Element el, HTML.Attribute cl, String value) {
        try {
            this.writeLock();
            AbstractDocument.DefaultDocumentEvent ev = new AbstractDocument.DefaultDocumentEvent(el.getStartOffset(), 1, DocumentEvent.EventType.CHANGE);
            AttributeSet elAtts = el.getAttributes();
            AttributeSet anchorAtts = (AttributeSet)elAtts.getAttribute(HTML.Tag.A);
            if (anchorAtts != null) {
                AttributeSet copy = elAtts.copyAttributes();
                StyleSheet ss = this.getStyleSheet();
                anchorAtts = value != null ? ss.addAttribute(anchorAtts, cl, value) : ss.removeAttribute(anchorAtts, cl);
                MutableAttributeSet matts = (MutableAttributeSet)elAtts;
                ev.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(el, copy, false));
                matts.removeAttribute(HTML.Tag.A);
                matts.addAttribute(HTML.Tag.A, anchorAtts);
                ev.end();
                this.fireChangedUpdate(ev);
                this.fireUndoableEditUpdate(new UndoableEditEvent(this, ev));
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public class BlockElement
    extends AbstractDocument.BranchElement {
        public BlockElement(Element parent, AttributeSet a) {
            super(parent, a);
        }

        public AttributeSet getResolveParent() {
            return null;
        }

        public String getName() {
            Object tag = this.getAttribute(StyleConstants.NameAttribute);
            String name = null;
            if (tag != null) {
                name = tag.toString();
            }
            if (name == null) {
                name = super.getName();
            }
            return name;
        }
    }

    public class HTMLReader
    extends HTMLEditorKit.ParserCallback {
        private static final int MAX_THRESHOLD = 10000;
        private static final int GROW_THRESHOLD = 5;
        protected MutableAttributeSet charAttr = new SimpleAttributeSet();
        protected Vector<DefaultStyledDocument.ElementSpec> parseBuffer = new Vector();
        private Stack<HTML.Tag> parseStack = new Stack();
        Stack charAttrStack = new Stack();
        HashMap tagToAction;
        boolean endHTMLEncountered = false;
        int popDepth;
        int pushDepth;
        int offset;
        HTML.Tag insertTag;
        boolean insertTagEncountered;
        boolean debug = false;
        boolean inPreTag = false;
        boolean inStyleTag = false;
        boolean inTextArea = false;
        ArrayList styles;
        ResetablePlainDocument textAreaDocument;
        Object selectModel;
        Option option;
        int numOptions;
        HashMap buttonGroups;
        private int threshold;

        public HTMLReader(int offset) {
            this(offset, 0, 0, null);
        }

        public HTMLReader(int offset, int popDepth, int pushDepth, HTML.Tag insertTag) {
            this.insertTag = insertTag;
            this.offset = offset;
            this.popDepth = popDepth;
            this.pushDepth = pushDepth;
            this.threshold = HTMLDocument.this.getTokenThreshold();
            this.initTags();
        }

        void initTags() {
            this.tagToAction = new HashMap(72);
            CharacterAction characterAction = new CharacterAction();
            HiddenAction hiddenAction = new HiddenAction();
            AreaAction areaAction = new AreaAction();
            BaseAction baseAction = new BaseAction();
            BlockAction blockAction = new BlockAction();
            SpecialAction specialAction = new SpecialAction();
            ParagraphAction paragraphAction = new ParagraphAction();
            HeadAction headAction = new HeadAction();
            FormAction formAction = new FormAction();
            IsindexAction isindexAction = new IsindexAction();
            LinkAction linkAction = new LinkAction();
            MapAction mapAction = new MapAction();
            PreAction preAction = new PreAction();
            MetaAction metaAction = new MetaAction();
            StyleAction styleAction = new StyleAction();
            TitleAction titleAction = new TitleAction();
            ConvertAction convertAction = new ConvertAction();
            this.tagToAction.put(HTML.Tag.A, characterAction);
            this.tagToAction.put(HTML.Tag.ADDRESS, characterAction);
            this.tagToAction.put(HTML.Tag.APPLET, hiddenAction);
            this.tagToAction.put(HTML.Tag.AREA, areaAction);
            this.tagToAction.put(HTML.Tag.B, characterAction);
            this.tagToAction.put(HTML.Tag.BASE, baseAction);
            this.tagToAction.put(HTML.Tag.BASEFONT, characterAction);
            this.tagToAction.put(HTML.Tag.BIG, characterAction);
            this.tagToAction.put(HTML.Tag.BLOCKQUOTE, blockAction);
            this.tagToAction.put(HTML.Tag.BODY, blockAction);
            this.tagToAction.put(HTML.Tag.BR, specialAction);
            this.tagToAction.put(HTML.Tag.CAPTION, blockAction);
            this.tagToAction.put(HTML.Tag.CENTER, blockAction);
            this.tagToAction.put(HTML.Tag.CITE, characterAction);
            this.tagToAction.put(HTML.Tag.CODE, characterAction);
            this.tagToAction.put(HTML.Tag.DD, blockAction);
            this.tagToAction.put(HTML.Tag.DFN, characterAction);
            this.tagToAction.put(HTML.Tag.DIR, blockAction);
            this.tagToAction.put(HTML.Tag.DIV, blockAction);
            this.tagToAction.put(HTML.Tag.DL, blockAction);
            this.tagToAction.put(HTML.Tag.DT, paragraphAction);
            this.tagToAction.put(HTML.Tag.EM, characterAction);
            this.tagToAction.put(HTML.Tag.FONT, convertAction);
            this.tagToAction.put(HTML.Tag.FORM, new FormTagAction());
            this.tagToAction.put(HTML.Tag.FRAME, specialAction);
            this.tagToAction.put(HTML.Tag.FRAMESET, blockAction);
            this.tagToAction.put(HTML.Tag.H1, paragraphAction);
            this.tagToAction.put(HTML.Tag.H2, paragraphAction);
            this.tagToAction.put(HTML.Tag.H3, paragraphAction);
            this.tagToAction.put(HTML.Tag.H4, paragraphAction);
            this.tagToAction.put(HTML.Tag.H5, paragraphAction);
            this.tagToAction.put(HTML.Tag.H6, paragraphAction);
            this.tagToAction.put(HTML.Tag.HEAD, headAction);
            this.tagToAction.put(HTML.Tag.HR, specialAction);
            this.tagToAction.put(HTML.Tag.HTML, blockAction);
            this.tagToAction.put(HTML.Tag.I, characterAction);
            this.tagToAction.put(HTML.Tag.IMG, specialAction);
            this.tagToAction.put(HTML.Tag.INPUT, formAction);
            this.tagToAction.put(HTML.Tag.ISINDEX, isindexAction);
            this.tagToAction.put(HTML.Tag.KBD, characterAction);
            this.tagToAction.put(HTML.Tag.LI, blockAction);
            this.tagToAction.put(HTML.Tag.LINK, linkAction);
            this.tagToAction.put(HTML.Tag.MAP, mapAction);
            this.tagToAction.put(HTML.Tag.MENU, blockAction);
            this.tagToAction.put(HTML.Tag.META, metaAction);
            this.tagToAction.put(HTML.Tag.NOFRAMES, blockAction);
            this.tagToAction.put(HTML.Tag.OBJECT, specialAction);
            this.tagToAction.put(HTML.Tag.OL, blockAction);
            this.tagToAction.put(HTML.Tag.OPTION, formAction);
            this.tagToAction.put(HTML.Tag.P, paragraphAction);
            this.tagToAction.put(HTML.Tag.PARAM, hiddenAction);
            this.tagToAction.put(HTML.Tag.PRE, preAction);
            this.tagToAction.put(HTML.Tag.SAMP, characterAction);
            this.tagToAction.put(HTML.Tag.SCRIPT, hiddenAction);
            this.tagToAction.put(HTML.Tag.SELECT, formAction);
            this.tagToAction.put(HTML.Tag.SMALL, characterAction);
            this.tagToAction.put(HTML.Tag.STRIKE, characterAction);
            this.tagToAction.put(HTML.Tag.S, characterAction);
            this.tagToAction.put(HTML.Tag.STRONG, characterAction);
            this.tagToAction.put(HTML.Tag.STYLE, styleAction);
            this.tagToAction.put(HTML.Tag.SUB, characterAction);
            this.tagToAction.put(HTML.Tag.SUP, characterAction);
            this.tagToAction.put(HTML.Tag.TABLE, blockAction);
            this.tagToAction.put(HTML.Tag.TD, blockAction);
            this.tagToAction.put(HTML.Tag.TEXTAREA, formAction);
            this.tagToAction.put(HTML.Tag.TH, blockAction);
            this.tagToAction.put(HTML.Tag.TITLE, titleAction);
            this.tagToAction.put(HTML.Tag.TR, blockAction);
            this.tagToAction.put(HTML.Tag.TT, characterAction);
            this.tagToAction.put(HTML.Tag.U, characterAction);
            this.tagToAction.put(HTML.Tag.UL, blockAction);
            this.tagToAction.put(HTML.Tag.VAR, characterAction);
        }

        protected void pushCharacterStyle() {
            this.charAttrStack.push(this.charAttr.copyAttributes());
        }

        protected void popCharacterStyle() {
            if (!this.charAttrStack.isEmpty()) {
                this.charAttr = (MutableAttributeSet)this.charAttrStack.pop();
            }
        }

        protected void registerTag(HTML.Tag t, TagAction a) {
            this.tagToAction.put(t, a);
        }

        public void flush() throws BadLocationException {
            this.flushImpl();
        }

        private void flushImpl() throws BadLocationException {
            int oldLen = HTMLDocument.this.getLength();
            int size = this.parseBuffer.size();
            Object[] elems = new DefaultStyledDocument.ElementSpec[size];
            this.parseBuffer.copyInto(elems);
            if (oldLen == 0) {
                HTMLDocument.this.create((DefaultStyledDocument.ElementSpec[])elems);
            } else {
                HTMLDocument.this.insert(this.offset, (DefaultStyledDocument.ElementSpec[])elems);
            }
            this.parseBuffer.removeAllElements();
            this.offset += HTMLDocument.this.getLength() - oldLen;
        }

        public void handleText(char[] data, int pos) {
            if (this.shouldInsert() && data != null && data.length > 0) {
                if (this.inTextArea) {
                    this.textAreaContent(data);
                } else if (this.inPreTag) {
                    this.preContent(data);
                } else if (this.option != null) {
                    this.option.setLabel(new String(data));
                } else if (this.inStyleTag) {
                    if (this.styles == null) {
                        this.styles = new ArrayList();
                    }
                    this.styles.add(new String(data));
                } else {
                    this.addContent(data, 0, data.length);
                }
            }
        }

        private boolean shouldInsert() {
            return !this.endHTMLEncountered && (this.insertTagEncountered || this.insertTag == null);
        }

        public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            TagAction action;
            if (t == this.insertTag) {
                this.insertTagEncountered = true;
            }
            if (this.shouldInsert() && (action = (TagAction)this.tagToAction.get(t)) != null) {
                action.start(t, a);
            }
        }

        public void handleComment(char[] data, int pos) {
            TagAction action;
            if (this.shouldInsert() && (action = (TagAction)this.tagToAction.get(HTML.Tag.COMMENT)) != null) {
                action.start(HTML.Tag.COMMENT, new SimpleAttributeSet());
                action.end(HTML.Tag.COMMENT);
            }
        }

        public void handleEndTag(HTML.Tag t, int pos) {
            if (this.shouldInsert()) {
                TagAction action;
                if (t == HTML.Tag.HTML) {
                    this.endHTMLEncountered = true;
                }
                if ((action = (TagAction)this.tagToAction.get(t)) != null) {
                    action.end(t);
                }
            }
        }

        public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            TagAction action;
            if (t == this.insertTag) {
                this.insertTagEncountered = true;
            }
            if (this.shouldInsert() && (action = (TagAction)this.tagToAction.get(t)) != null) {
                action.start(t, a);
                action.end(t);
            }
        }

        public void handleEndOfLineString(String eol) {
        }

        protected void textAreaContent(char[] data) {
            block2: {
                try {
                    int offset = this.textAreaDocument.getLength();
                    String text = new String(data);
                    this.textAreaDocument.setInitialText(text);
                    this.textAreaDocument.insertString(offset, text, null);
                }
                catch (BadLocationException badLocationException) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError();
                }
            }
        }

        protected void preContent(char[] data) {
            int start = 0;
            int i = 0;
            while (i < data.length) {
                if (data[i] == '\n') {
                    this.addContent(data, start, i - start + 1);
                    this.blockClose(HTML.Tag.IMPLIED);
                    SimpleAttributeSet atts = new SimpleAttributeSet();
                    atts.addAttribute(CSS.Attribute.WHITE_SPACE, "pre");
                    this.blockOpen(HTML.Tag.IMPLIED, atts);
                    start = i + 1;
                }
                ++i;
            }
            if (start < data.length) {
                this.addContent(data, start, data.length - start);
            }
        }

        protected void blockOpen(HTML.Tag t, MutableAttributeSet attr) {
            if (this.inImpliedParagraph()) {
                this.blockClose(HTML.Tag.IMPLIED);
            }
            this.parseStack.push(t);
            AbstractDocument.AttributeContext ctx = HTMLDocument.this.getAttributeContext();
            AttributeSet copy = attr.copyAttributes();
            copy = ctx.addAttribute(copy, StyleConstants.NameAttribute, t);
            DefaultStyledDocument.ElementSpec element = new DefaultStyledDocument.ElementSpec(copy, 1);
            this.parseBuffer.addElement(element);
        }

        private boolean inParagraph() {
            boolean inParagraph = false;
            if (!this.parseStack.isEmpty()) {
                HTML.Tag top = this.parseStack.peek();
                inParagraph = top == HTML.Tag.P || top == HTML.Tag.IMPLIED;
            }
            return inParagraph;
        }

        private boolean inImpliedParagraph() {
            boolean inParagraph = false;
            if (!this.parseStack.isEmpty()) {
                HTML.Tag top = this.parseStack.peek();
                inParagraph = top == HTML.Tag.IMPLIED;
            }
            return inParagraph;
        }

        protected void blockClose(HTML.Tag t) {
            DefaultStyledDocument.ElementSpec prev;
            if (this.inImpliedParagraph() && t != HTML.Tag.IMPLIED) {
                this.blockClose(HTML.Tag.IMPLIED);
            }
            if (!this.parseStack.isEmpty()) {
                this.parseStack.pop();
            }
            DefaultStyledDocument.ElementSpec elementSpec = prev = this.parseBuffer.size() > 0 ? this.parseBuffer.get(this.parseBuffer.size() - 1) : null;
            if (prev != null && prev.getType() == 1) {
                this.addContent(new char[]{' '}, 0, 1);
            }
            DefaultStyledDocument.ElementSpec element = new DefaultStyledDocument.ElementSpec(null, 2);
            this.parseBuffer.addElement(element);
        }

        protected void addContent(char[] data, int offs, int length) {
            this.addContent(data, offs, length, true);
        }

        protected void addContent(char[] data, int offs, int length, boolean generateImpliedPIfNecessary) {
            if (generateImpliedPIfNecessary && !this.inParagraph()) {
                this.blockOpen(HTML.Tag.IMPLIED, new SimpleAttributeSet());
            }
            AbstractDocument.AttributeContext ctx = HTMLDocument.this.getAttributeContext();
            AttributeSet attributes = null;
            attributes = this.charAttr != null ? this.charAttr.copyAttributes() : ctx.getEmptySet();
            attributes = ctx.addAttribute(attributes, StyleConstants.NameAttribute, HTML.Tag.CONTENT);
            DefaultStyledDocument.ElementSpec element = new DefaultStyledDocument.ElementSpec(attributes, 3, data, offs, length);
            this.parseBuffer.addElement(element);
            if (this.parseBuffer.size() > this.threshold) {
                if (this.threshold <= 10000) {
                    this.threshold *= 5;
                }
                try {
                    this.flushImpl();
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        protected void addSpecialElement(HTML.Tag t, MutableAttributeSet a) {
            if (t != HTML.Tag.FRAME && !this.inParagraph()) {
                this.blockOpen(HTML.Tag.IMPLIED, new SimpleAttributeSet());
            }
            a.addAttribute(StyleConstants.NameAttribute, t);
            DefaultStyledDocument.ElementSpec spec = new DefaultStyledDocument.ElementSpec(a.copyAttributes(), 3, new char[]{' '}, 0, 1);
            this.parseBuffer.add(spec);
        }

        class AreaAction
        extends TagAction {
            AreaAction() {
            }

            public void start(HTML.Tag t, MutableAttributeSet a) throws NotImplementedException {
            }

            public void end(HTML.Tag t) throws NotImplementedException {
            }
        }

        class BaseAction
        extends TagAction {
            BaseAction() {
            }

            public void start(HTML.Tag t, MutableAttributeSet a) {
                ((HTMLReader)HTMLReader.this).HTMLDocument.this.baseTarget = (String)a.getAttribute(HTML.Attribute.TARGET);
            }
        }

        public class BlockAction
        extends TagAction {
            public void start(HTML.Tag t, MutableAttributeSet a) {
                HTMLReader.this.blockOpen(t, a);
            }

            public void end(HTML.Tag t) {
                HTMLReader.this.blockClose(t);
            }
        }

        public class CharacterAction
        extends TagAction {
            public void start(HTML.Tag t, MutableAttributeSet a) {
                HTMLReader.this.pushCharacterStyle();
                if (t == HTML.Tag.A) {
                    a.addAttribute(HTML.Attribute.PSEUDO_CLASS, "link");
                }
                HTMLReader.this.charAttr.addAttribute(t, a.copyAttributes());
            }

            public void end(HTML.Tag t) {
                HTMLReader.this.popCharacterStyle();
            }
        }

        class ConvertAction
        extends TagAction {
            ConvertAction() {
            }

            public void start(HTML.Tag tag, MutableAttributeSet atts) {
                HTMLReader.this.pushCharacterStyle();
                HTMLReader.this.charAttr.addAttribute(tag, atts.copyAttributes());
                StyleSheet styleSheet = HTMLDocument.this.getStyleSheet();
                if (tag == HTML.Tag.FONT) {
                    String size;
                    String face;
                    String color = (String)atts.getAttribute(HTML.Attribute.COLOR);
                    if (color != null) {
                        styleSheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.COLOR, color);
                    }
                    if ((face = (String)atts.getAttribute(HTML.Attribute.FACE)) != null) {
                        styleSheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.FONT_FAMILY, face);
                    }
                    if ((size = (String)atts.getAttribute(HTML.Attribute.SIZE)) != null) {
                        styleSheet.addCSSAttribute(HTMLReader.this.charAttr, CSS.Attribute.FONT_SIZE, size);
                    }
                }
            }

            public void end(HTML.Tag tag) {
                HTMLReader.this.popCharacterStyle();
            }
        }

        public class FormAction
        extends SpecialAction {
            public void start(HTML.Tag t, MutableAttributeSet a) {
                if (t == HTML.Tag.INPUT) {
                    String type = (String)a.getAttribute(HTML.Attribute.TYPE);
                    if (type == null) {
                        type = "text";
                        a.addAttribute(HTML.Attribute.TYPE, type);
                    }
                    this.setModel(type, a);
                } else if (t == HTML.Tag.TEXTAREA) {
                    HTMLReader.this.inTextArea = true;
                    HTMLReader.this.textAreaDocument = new ResetablePlainDocument();
                    a.addAttribute(StyleConstants.ModelAttribute, HTMLReader.this.textAreaDocument);
                } else if (t == HTML.Tag.SELECT) {
                    boolean multi;
                    int size = HTML.getIntegerAttributeValue(a, HTML.Attribute.SIZE, 1);
                    boolean bl = multi = a.getAttribute(HTML.Attribute.MULTIPLE) != null;
                    if (size > 1 || multi) {
                        SelectListModel m = new SelectListModel();
                        if (multi) {
                            m.getSelectionModel().setSelectionMode(2);
                        }
                        HTMLReader.this.selectModel = m;
                    } else {
                        HTMLReader.this.selectModel = new SelectComboBoxModel();
                    }
                    a.addAttribute(StyleConstants.ModelAttribute, HTMLReader.this.selectModel);
                }
                if (t == HTML.Tag.OPTION) {
                    HTMLReader.this.option = new Option(a);
                    if (HTMLReader.this.selectModel instanceof SelectListModel) {
                        SelectListModel m = (SelectListModel)HTMLReader.this.selectModel;
                        m.addElement(HTMLReader.this.option);
                        if (HTMLReader.this.option.isSelected()) {
                            m.getSelectionModel().addSelectionInterval(HTMLReader.this.numOptions, HTMLReader.this.numOptions);
                            m.addInitialSelection(HTMLReader.this.numOptions);
                        }
                    } else if (HTMLReader.this.selectModel instanceof SelectComboBoxModel) {
                        SelectComboBoxModel m = (SelectComboBoxModel)HTMLReader.this.selectModel;
                        m.addElement(HTMLReader.this.option);
                        if (HTMLReader.this.option.isSelected()) {
                            m.setSelectedItem(HTMLReader.this.option);
                            m.setInitialSelection(HTMLReader.this.option);
                        }
                    }
                    ++HTMLReader.this.numOptions;
                } else {
                    super.start(t, a);
                }
            }

            public void end(HTML.Tag t) {
                if (t == HTML.Tag.OPTION) {
                    HTMLReader.this.option = null;
                } else {
                    if (t == HTML.Tag.TEXTAREA) {
                        HTMLReader.this.inTextArea = false;
                    } else if (t == HTML.Tag.SELECT) {
                        HTMLReader.this.selectModel = null;
                        HTMLReader.this.numOptions = 0;
                    }
                    super.end(t);
                }
            }

            private void setModel(String type, MutableAttributeSet attrs) {
                if (type.equals("submit") || type.equals("reset") || type.equals("image")) {
                    attrs.addAttribute(StyleConstants.ModelAttribute, new DefaultButtonModel());
                } else if (type.equals("text") || type.equals("password")) {
                    ResetablePlainDocument doc;
                    block14: {
                        String text = (String)attrs.getAttribute(HTML.Attribute.VALUE);
                        doc = new ResetablePlainDocument();
                        if (text != null) {
                            doc.setInitialText(text);
                            try {
                                doc.insertString(0, text, null);
                            }
                            catch (BadLocationException badLocationException) {
                                if ($assertionsDisabled) break block14;
                                throw new AssertionError();
                            }
                        }
                    }
                    attrs.addAttribute(StyleConstants.ModelAttribute, doc);
                } else if (type.equals("file")) {
                    attrs.addAttribute(StyleConstants.ModelAttribute, new PlainDocument());
                } else if (type.equals("checkbox") || type.equals("radio")) {
                    String name;
                    ResetableToggleButtonModel model = new ResetableToggleButtonModel();
                    if (attrs.getAttribute(HTML.Attribute.SELECTED) != null) {
                        model.setSelected(true);
                        model.setInitial(true);
                    }
                    if (type.equals("radio") && (name = (String)attrs.getAttribute(HTML.Attribute.NAME)) != null) {
                        ButtonGroup group;
                        if (HTMLReader.this.buttonGroups == null) {
                            HTMLReader.this.buttonGroups = new HashMap();
                        }
                        if ((group = (ButtonGroup)HTMLReader.this.buttonGroups.get(name)) == null) {
                            group = new ButtonGroup();
                            HTMLReader.this.buttonGroups.put(name, group);
                        }
                        model.setGroup(group);
                    }
                    attrs.addAttribute(StyleConstants.ModelAttribute, model);
                }
            }
        }

        class FormTagAction
        extends BlockAction {
            FormTagAction() {
            }

            public void end(HTML.Tag t) {
                super.end(t);
                HTMLReader.this.buttonGroups = null;
            }
        }

        class HeadAction
        extends BlockAction {
            HeadAction() {
            }

            public void start(HTML.Tag t, MutableAttributeSet a) throws NotImplementedException {
                super.start(t, a);
            }

            public void end(HTML.Tag t) {
                if (HTMLReader.this.styles != null) {
                    int numStyles = HTMLReader.this.styles.size();
                    int i = 0;
                    while (i < numStyles) {
                        String style = (String)HTMLReader.this.styles.get(i);
                        HTMLDocument.this.getStyleSheet().addRule(style);
                        ++i;
                    }
                }
                super.end(t);
            }
        }

        public class HiddenAction
        extends TagAction {
            public void start(HTML.Tag t, MutableAttributeSet a) {
                HTMLReader.this.blockOpen(t, a);
            }

            public void end(HTML.Tag t) {
                HTMLReader.this.blockClose(t);
            }
        }

        public class IsindexAction
        extends TagAction {
            public void start(HTML.Tag t, MutableAttributeSet a) {
                HTMLReader.this.blockOpen(HTML.Tag.IMPLIED, new SimpleAttributeSet());
                HTMLReader.this.addSpecialElement(t, a);
                HTMLReader.this.blockClose(HTML.Tag.IMPLIED);
            }
        }

        class LinkAction
        extends HiddenAction {
            LinkAction() {
            }

            public void start(HTML.Tag t, MutableAttributeSet a) {
                super.start(t, a);
                String type = (String)a.getAttribute(HTML.Attribute.TYPE);
                if (type == null) {
                    type = "text/css";
                }
                if (type.equals("text/css")) {
                    String rel = (String)a.getAttribute(HTML.Attribute.REL);
                    String media = (String)a.getAttribute(HTML.Attribute.MEDIA);
                    String cfr_ignored_0 = (String)a.getAttribute(HTML.Attribute.TITLE);
                    media = media == null ? "all" : media.toLowerCase();
                    if (rel != null) {
                        rel = rel.toLowerCase();
                        if ((media.indexOf("all") != -1 || media.indexOf("screen") != -1) && rel.equals("stylesheet")) {
                            String href = (String)a.getAttribute(HTML.Attribute.HREF);
                            URL url = null;
                            try {
                                url = new URL(((HTMLReader)HTMLReader.this).HTMLDocument.this.baseURL, href);
                            }
                            catch (MalformedURLException malformedURLException) {
                                try {
                                    url = new URL(href);
                                }
                                catch (MalformedURLException malformedURLException2) {
                                    url = null;
                                }
                            }
                            if (url != null) {
                                try {
                                    HTMLDocument.this.getStyleSheet().importStyleSheet(url);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        }
                    }
                }
            }
        }

        class MapAction
        extends TagAction {
            MapAction() {
            }

            public void start(HTML.Tag t, MutableAttributeSet a) throws NotImplementedException {
            }

            public void end(HTML.Tag t) throws NotImplementedException {
            }
        }

        class MetaAction
        extends TagAction {
            MetaAction() {
            }

            public void start(HTML.Tag t, MutableAttributeSet a) throws NotImplementedException {
            }

            public void end(HTML.Tag t) throws NotImplementedException {
            }
        }

        public class ParagraphAction
        extends BlockAction {
            public void start(HTML.Tag t, MutableAttributeSet a) {
                super.start(t, a);
            }

            public void end(HTML.Tag t) {
                super.end(t);
            }
        }

        public class PreAction
        extends BlockAction {
            public void start(HTML.Tag t, MutableAttributeSet a) {
                HTMLReader.this.inPreTag = true;
                HTMLReader.this.blockOpen(t, a);
                a.addAttribute(CSS.Attribute.WHITE_SPACE, "pre");
                HTMLReader.this.blockOpen(HTML.Tag.IMPLIED, a);
            }

            public void end(HTML.Tag t) {
                HTMLReader.this.blockClose(HTML.Tag.IMPLIED);
                HTMLReader.this.inPreTag = false;
                HTMLReader.this.blockClose(t);
            }
        }

        public class SpecialAction
        extends TagAction {
            public void start(HTML.Tag t, MutableAttributeSet a) {
                HTMLReader.this.addSpecialElement(t, a);
            }
        }

        class StyleAction
        extends TagAction {
            StyleAction() {
            }

            public void start(HTML.Tag t, MutableAttributeSet a) {
                HTMLReader.this.inStyleTag = true;
            }

            public void end(HTML.Tag t) {
                HTMLReader.this.inStyleTag = false;
            }
        }

        public class TagAction {
            public void start(HTML.Tag t, MutableAttributeSet a) {
            }

            public void end(HTML.Tag t) {
            }
        }

        class TitleAction
        extends TagAction {
            TitleAction() {
            }

            public void start(HTML.Tag t, MutableAttributeSet a) throws NotImplementedException {
            }

            public void end(HTML.Tag t) throws NotImplementedException {
            }
        }
    }

    public static abstract class Iterator {
        public abstract AttributeSet getAttributes();

        public abstract int getEndOffset();

        public abstract int getStartOffset();

        public abstract void next();

        public abstract boolean isValid();

        public abstract HTML.Tag getTag();
    }

    class LeafIterator
    extends Iterator {
        HTML.Tag tag;
        HTMLDocument doc;
        ElementIterator it;

        public LeafIterator(HTML.Tag t, HTMLDocument d) {
            this.doc = d;
            this.tag = t;
            this.it = new ElementIterator(this.doc);
        }

        public AttributeSet getAttributes() {
            if (this.it.current() != null) {
                return this.it.current().getAttributes();
            }
            return null;
        }

        public int getEndOffset() {
            if (this.it.current() != null) {
                return this.it.current().getEndOffset();
            }
            return -1;
        }

        public int getStartOffset() {
            if (this.it.current() != null) {
                return this.it.current().getStartOffset();
            }
            return -1;
        }

        public void next() {
            this.it.next();
            while (this.it.current() != null && !this.it.current().isLeaf()) {
                this.it.next();
            }
        }

        public boolean isValid() {
            return this.it.current() != null;
        }

        public HTML.Tag getTag() {
            return this.tag;
        }
    }

    public class RunElement
    extends AbstractDocument.LeafElement {
        public RunElement(Element parent, AttributeSet a, int start, int end) {
            super(parent, a, start, end);
        }

        public String getName() {
            Object tag = this.getAttribute(StyleConstants.NameAttribute);
            String name = null;
            if (tag != null) {
                name = tag.toString();
            }
            if (name == null) {
                name = super.getName();
            }
            return name;
        }

        public AttributeSet getResolveParent() {
            return null;
        }
    }
}

