/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.java.lang.CPStringBuilder;
import gnu.xml.xpath.XPathParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.TreeMap;

public class XPathTokenizer
implements XPathParser.yyInput {
    static final Map<String, Integer> keywords = new TreeMap<String, Integer>();
    Reader in;
    XPathToken token;
    XPathToken lastToken;

    static {
        keywords.put("ancestor", new Integer(283));
        keywords.put("ancestor-or-self", new Integer(284));
        keywords.put("attribute", new Integer(285));
        keywords.put("child", new Integer(286));
        keywords.put("descendant", new Integer(287));
        keywords.put("descendant-or-self", new Integer(288));
        keywords.put("following", new Integer(289));
        keywords.put("following-sibling", new Integer(290));
        keywords.put("namespace", new Integer(291));
        keywords.put("parent", new Integer(292));
        keywords.put("preceding", new Integer(293));
        keywords.put("preceding-sibling", new Integer(294));
        keywords.put("self", new Integer(295));
        keywords.put("div", new Integer(296));
        keywords.put("mod", new Integer(297));
        keywords.put("or", new Integer(298));
        keywords.put("and", new Integer(299));
        keywords.put("comment", new Integer(300));
        keywords.put("processing-instruction", new Integer(301));
        keywords.put("text", new Integer(302));
        keywords.put("node", new Integer(303));
    }

    public XPathTokenizer(String expr) {
        this(new StringReader(expr));
    }

    XPathTokenizer(Reader in) {
        this.in = in.markSupported() ? in : new BufferedReader(in);
    }

    public boolean advance() throws IOException {
        this.lastToken = this.token;
        int c = this.in.read();
        switch (c) {
            case -1: {
                return false;
            }
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return this.advance();
            }
            case 34: 
            case 39: {
                this.token = this.consume_literal(c);
                break;
            }
            case 40: {
                this.token = new XPathToken(260);
                break;
            }
            case 41: {
                this.token = new XPathToken(261);
                break;
            }
            case 91: {
                this.token = new XPathToken(262);
                break;
            }
            case 93: {
                this.token = new XPathToken(263);
                break;
            }
            case 44: {
                this.token = new XPathToken(264);
                break;
            }
            case 124: {
                this.token = new XPathToken(265);
                break;
            }
            case 47: {
                this.in.mark(1);
                int d1 = this.in.read();
                if (d1 == 47) {
                    this.token = new XPathToken(267);
                    break;
                }
                this.in.reset();
                this.token = new XPathToken(266);
                break;
            }
            case 61: {
                this.token = new XPathToken(268);
                break;
            }
            case 33: {
                this.in.mark(1);
                int d2 = this.in.read();
                if (d2 == 61) {
                    this.token = new XPathToken(269);
                    break;
                }
                this.in.reset();
                this.token = new XPathToken(256);
                break;
            }
            case 62: {
                this.in.mark(1);
                int d3 = this.in.read();
                if (d3 == 61) {
                    this.token = new XPathToken(272);
                    break;
                }
                this.in.reset();
                this.token = new XPathToken(270);
                break;
            }
            case 60: {
                this.in.mark(1);
                int d4 = this.in.read();
                if (d4 == 61) {
                    this.token = new XPathToken(273);
                    break;
                }
                this.in.reset();
                this.token = new XPathToken(271);
                break;
            }
            case 43: {
                this.token = new XPathToken(274);
                break;
            }
            case 45: {
                this.token = new XPathToken(275);
                break;
            }
            case 64: {
                this.token = new XPathToken(276);
                break;
            }
            case 42: {
                this.token = new XPathToken(277);
                break;
            }
            case 36: {
                this.token = new XPathToken(278);
                break;
            }
            case 58: {
                this.in.mark(1);
                int d5 = this.in.read();
                if (d5 == 58) {
                    this.token = new XPathToken(280);
                    break;
                }
                this.in.reset();
                this.token = new XPathToken(279);
                break;
            }
            case 46: {
                this.in.mark(1);
                int d6 = this.in.read();
                if (d6 == 46) {
                    this.token = new XPathToken(282);
                    break;
                }
                this.in.reset();
                this.token = new XPathToken(281);
                break;
            }
            default: {
                this.token = c >= 48 && c <= 57 ? this.consume_digits(c) : (c == 95 || Character.isLetter((char)c) ? this.consume_name(c) : new XPathToken(256));
            }
        }
        return true;
    }

    public int token() {
        return this.token.type;
    }

    public Object value() {
        return this.token.val;
    }

    XPathToken consume_literal(int delimiter) throws IOException {
        CPStringBuilder buf = new CPStringBuilder();
        int c;
        while ((c = this.in.read()) != -1) {
            if (c == delimiter) {
                return new XPathToken(257, buf.toString());
            }
            buf.append((char)c);
        }
        return new XPathToken(256);
    }

    XPathToken consume_digits(int c) throws IOException {
        CPStringBuilder buf = new CPStringBuilder();
        buf.append((char)c);
        while (true) {
            this.in.mark(1);
            c = this.in.read();
            if (c < 48 || c > 57) break;
            buf.append((char)c);
        }
        this.in.reset();
        return new XPathToken(258, buf.toString());
    }

    XPathToken consume_name(int c) throws IOException {
        CPStringBuilder buf = new CPStringBuilder();
        buf.append((char)c);
        while (true) {
            this.in.mark(1);
            c = this.in.read();
            if (!this.isNameChar(c)) break;
            buf.append((char)c);
        }
        this.in.reset();
        String name = buf.toString();
        Integer keyword = keywords.get(name);
        if (keyword == null) {
            return new XPathToken(259, name);
        }
        int val = keyword;
        switch (val) {
            case 300: 
            case 301: 
            case 302: 
            case 303: {
                this.in.mark(1);
                while ((c = this.in.read()) == 32 || c == 9) {
                }
                if (c == 40) break;
                this.in.reset();
                return new XPathToken(259, name);
            }
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: {
                this.in.mark(1);
                while ((c = this.in.read()) == 32 || c == 9) {
                }
                if (c == 58 && (c = this.in.read()) == 58) {
                    this.in.reset();
                    return new XPathToken(val);
                }
                this.in.reset();
                return new XPathToken(259, name);
            }
            case 296: 
            case 297: {
                if (this.lastToken == null) {
                    return new XPathToken(259, name);
                }
                switch (this.lastToken.type) {
                    case 260: 
                    case 262: 
                    case 264: 
                    case 265: 
                    case 266: 
                    case 268: 
                    case 269: 
                    case 270: 
                    case 271: 
                    case 272: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 277: 
                    case 278: 
                    case 279: 
                    case 280: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 299: {
                        return new XPathToken(259, name);
                    }
                }
            }
        }
        return new XPathToken(val);
    }

    boolean isNameChar(int c) {
        return c == 95 || c == 45 || c == 46 || c >= 48 && c <= 57 || c >= 768 && c <= 837 || c >= 864 && c <= 865 || c >= 1155 && c <= 1158 || c >= 1425 && c <= 1441 || c >= 1443 && c <= 1465 || c >= 1467 && c <= 1469 || c == 1471 || c >= 1473 && c <= 1474 || c == 1476 || c >= 1611 && c <= 1618 || c == 1648 || c >= 1750 && c <= 1756 || c >= 1757 && c <= 1759 || c >= 1760 && c <= 1764 || c >= 1767 && c <= 1768 || c >= 1770 && c <= 1773 || c >= 2305 && c <= 2307 || c == 2364 || c >= 2366 && c <= 2380 || c == 2381 || c >= 2385 && c <= 2388 || c >= 2402 && c <= 2403 || c >= 2433 && c <= 2435 || c == 2492 || c == 2494 || c == 2495 || c >= 2496 && c <= 2500 || c >= 2503 && c <= 2504 || c >= 2507 && c <= 2509 || c == 2519 || c >= 2530 && c <= 2531 || c == 2562 || c == 2620 || c == 2622 || c == 2623 || c >= 2624 && c <= 2626 || c >= 2631 && c <= 2632 || c >= 2635 && c <= 2637 || c >= 2672 && c <= 2673 || c >= 2689 && c <= 2691 || c == 2748 || c >= 2750 && c <= 2757 || c >= 2759 && c <= 2761 || c >= 2763 && c <= 2765 || c >= 2817 && c <= 2819 || c == 2876 || c >= 2878 && c <= 2883 || c >= 2887 && c <= 2888 || c >= 2891 && c <= 2893 || c >= 2902 && c <= 2903 || c >= 2946 && c <= 2947 || c >= 3006 && c <= 3010 || c >= 3014 && c <= 3016 || c >= 3018 && c <= 3021 || c == 3031 || c >= 3073 && c <= 3075 || c >= 3134 && c <= 3140 || c >= 3142 && c <= 3144 || c >= 3146 && c <= 3149 || c >= 3157 && c <= 3158 || c >= 3202 && c <= 3203 || c >= 3262 && c <= 3268 || c >= 3270 && c <= 3272 || c >= 3274 && c <= 3277 || c >= 3285 && c <= 3286 || c >= 3330 && c <= 3331 || c >= 3390 && c <= 3395 || c >= 3398 && c <= 3400 || c >= 3402 && c <= 3405 || c == 3415 || c == 3633 || c >= 3636 && c <= 3642 || c >= 3655 && c <= 3662 || c == 3761 || c >= 3764 && c <= 3769 || c >= 3771 && c <= 3772 || c >= 3784 && c <= 3789 || c >= 3864 && c <= 3865 || c == 3893 || c == 3895 || c == 3897 || c == 3902 || c == 3903 || c >= 3953 && c <= 3972 || c >= 3974 && c <= 3979 || c >= 3984 && c <= 3989 || c == 3991 || c >= 3993 && c <= 4013 || c >= 4017 && c <= 4023 || c == 4025 || c >= 8400 && c <= 8412 || c == 8417 || c >= 12330 && c <= 12335 || c == 12441 || c == 12442 || c == 183 || c == 720 || c == 721 || c == 903 || c == 1600 || c == 3654 || c == 3782 || c == 12293 || c >= 12337 && c <= 12341 || c >= 12445 && c <= 12446 || c >= 12540 && c <= 12542 || Character.isLetter((char)c);
    }

    static class XPathToken {
        int type;
        String val;

        XPathToken(int type) {
            this(type, null);
        }

        XPathToken(int type, String val) {
            this.type = type;
            this.val = val;
        }

        public String getText() {
            return this.val;
        }

        public String toString() {
            return this.val;
        }
    }
}

