/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class TokenType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{1, 2, 3, 4, 5, 6};

    TokenType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "token"), TypeLibrary.NORMALIZED_STRING);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String value, ValidationContext context) throws DatatypeException {
        super.checkValid(value, context);
        int len = value.length();
        if (len == 0) {
            throw new DatatypeException(0, "invalid token value");
        }
        if (value.charAt(0) == ' ' || value.charAt(len - 1) == ' ') {
            throw new DatatypeException(0, "invalid token value");
        }
        char last = '\u0000';
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            if (c == '\n' || c == '\r' || c == '\t') {
                throw new DatatypeException(i, "invalid token value");
            }
            if (c == ' ' && last == ' ') {
                throw new DatatypeException(i, "invalid token value");
            }
            last = c;
            ++i;
        }
    }
}

