/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.prefs;

import gnu.classpath.SystemProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Properties;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;

public class FileBasedPreferences
extends AbstractPreferences {
    private static final String DATA_FILE = "data.properties";
    private File directory;
    private File dataFile;
    private Properties properties;

    FileBasedPreferences() {
        super(null, "");
        String home = SystemProperties.getProperty("user.home");
        this.directory = new File(new File(home, ".classpath"), "userPrefs");
        this.dataFile = new File(this.directory, DATA_FILE);
        this.load();
    }

    FileBasedPreferences(FileBasedPreferences parent, String name) {
        super(parent, name);
        this.directory = new File(parent.directory, name);
        this.dataFile = new File(this.directory, DATA_FILE);
        this.load();
    }

    private void load() {
        block23: {
            this.properties = new Properties();
            FileInputStream fis = null;
            FileLock lock = null;
            try {
                try {
                    fis = new FileInputStream(this.dataFile);
                    FileChannel channel = fis.getChannel();
                    lock = channel.lock(0L, Long.MAX_VALUE, true);
                    this.properties.load(fis);
                }
                catch (IOException iOException) {
                    this.newNode = true;
                    try {
                        if (lock != null) {
                            lock.release();
                        }
                    }
                    catch (IOException iOException2) {}
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        break block23;
                    }
                    catch (IOException iOException3) {}
                    break block23;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (lock != null) {
                        lock.release();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (lock != null) {
                    lock.release();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public boolean isUserNode() {
        return true;
    }

    protected String[] childrenNamesSpi() throws BackingStoreException {
        String[] result = this.directory.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return new File(dir, name).isDirectory();
            }
        });
        if (result == null) {
            result = new String[]{};
        }
        return result;
    }

    protected AbstractPreferences childSpi(String name) {
        return new FileBasedPreferences(this, name);
    }

    protected String[] keysSpi() throws BackingStoreException {
        return this.properties.keySet().toArray(new String[0]);
    }

    protected String getSpi(String key) {
        return this.properties.getProperty(key);
    }

    protected void putSpi(String key, String value) {
        this.properties.put(key, value);
    }

    protected void removeSpi(String key) {
        this.properties.remove(key);
    }

    protected void flushSpi() throws BackingStoreException {
        block17: {
            try {
                if (this.isRemoved()) {
                    this.dataFile.delete();
                    break block17;
                }
                this.directory.mkdirs();
                FileOutputStream fos = null;
                FileLock lock = null;
                try {
                    fos = new FileOutputStream(this.dataFile);
                    FileChannel channel = fos.getChannel();
                    lock = channel.lock();
                    this.properties.store(fos, "created by GNU Classpath FileBasedPreferences");
                }
                catch (Throwable throwable) {
                    try {
                        if (lock != null) {
                            lock.release();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (lock != null) {
                        lock.release();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException iOException) {}
            }
            catch (IOException ioe) {
                throw new BackingStoreException(ioe);
            }
        }
    }

    protected void syncSpi() throws BackingStoreException {
        this.flushSpi();
    }

    protected void removeNodeSpi() throws BackingStoreException {
        this.flushSpi();
    }
}

