/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.java2d;

import java.awt.geom.Point2D;

public abstract class Segment
implements Cloneable {
    public Point2D P1 = null;
    public Point2D P2 = null;
    public Segment first = this;
    public Segment next = null;
    public Segment last = this;
    protected double radius;

    public void add(Segment newsegment) {
        newsegment.first = this.first;
        this.last.next = newsegment;
        this.last = this.last.next.last;
    }

    public void reverseAll() {
        this.reverse();
        this.first = this.last;
        Segment v = this.next;
        Segment former = this;
        this.next = null;
        while (v != null) {
            v.reverse();
            v.last = this;
            Segment oldnext = v.next;
            v.next = former;
            former = v;
            v = oldnext;
        }
    }

    public String toString() {
        return "Segment:" + this.P1 + ", " + this.P2;
    }

    protected double[] normal(double x0, double y0, double x1, double y1) {
        double dx = x1 - x0;
        double dy = y1 - y0;
        if (dy == 0.0) {
            dy = this.radius * (double)(dx > 0.0 ? 1 : -1);
            dx = 0.0;
        } else if (dx == 0.0) {
            dx = this.radius * (double)(dy > 0.0 ? -1 : 1);
            dy = 0.0;
        } else {
            double N = Math.sqrt(dx * dx + dy * dy);
            double odx = dx;
            dx = -this.radius * dy / N;
            dy = this.radius * odx / N;
        }
        return new double[]{dx, dy};
    }

    public abstract void reverse();

    public abstract Segment[] getDisplacedSegments(double var1);

    public abstract double[] cp1();

    public abstract double[] cp2();
}

